package gov.va.fnod.soa_web.ws;

import gov.va.cem.docstorage.service.DocumentStorageSession;
import gov.va.fnod.model.UserPrivilege;
import gov.va.fnod.model.fnoddata.CaseLink;
import gov.va.fnod.model.fnoddata.CaseType;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.model.fnoddata.SourceSystem;
import gov.va.fnod.security.authorization.SecurityContext;
import gov.va.fnod.security.exception.AuthenticationException;
import gov.va.fnod.security.exception.SecuritySystemException;
import gov.va.fnod.service.CaseSession;
import gov.va.fnod.service.LookupSession;
import gov.va.fnod.service.UserAuthenticationSession;
import gov.va.fnod.service.UserAuthorizationSession;
import gov.va.fnod.soa_common.model.flagapp.Authentication;
import gov.va.fnod.soa_common.model.flagapp.FlagApp;
import gov.va.fnod.soa_common.model.flagapp.FlagAppPayload;
import gov.va.fnod.soa_common.model.flagapp.PasswordChange;
import gov.va.fnod.soa_web.exception.CustomSOAPFaultException;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.ejb.EJB;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

//@MTOM
@WebService
	(
		name = "FlagAppPayloadService", 
		targetNamespace = "http://flagappservice.fnod.domain", 
		serviceName = "FlagAppPayloadService", 
		portName = "FlagAppPayload", 
		wsdlLocation = "WEB-INF/wsdl/FlagAppPayload.wsdl"
	)
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
public class FlagAppPayloadService {
	private static final Logger logr = Logger.getLogger(FlagAppPayloadService.class.getName());
	private static final String FLAGAPP = "FLAG_APP_LOADER: ";
	@EJB
	private LookupSession lookupSession;
	@EJB
	private CaseSession caseSession;
	@EJB
	private DocumentStorageSession documentStorageSession;
	private CustomSOAPFaultException soapFaultException;

	@EJB
	private UserAuthenticationSession userAuthenticSession;
	@EJB
	private UserAuthorizationSession userAuthorizationSession;

	@WebResult(name = "isAuthorized")
	public boolean authFlagAppUser(Authentication authentication) {

		if (authentication == null) {
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException
					.createSOAPFaultExceptionClient("Illegal Argument: The Authentication element cannnot be null.");
		}
		// Try and login
		boolean retval = true;
		try {
			SecurityContext<UserPrivilege> flagAppSecContext = userAuthorizationSession.createSystemContext(
					"FlagAppLogin", UserPrivilege.FLAG_APP_LOAD, UserPrivilege.CONNECT);
			userAuthenticSession.connect(authentication.getUsername(), authentication.getPassword(),
					flagAppSecContext);
		} catch (AuthenticationException e) {
			logr.log(Level.WARNING, "{0} failed a FLAG_APP login {1}: {2}", new Object[]{authentication.getUsername(), new Date(), e.getMessage()});
			retval = false;
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException.createSOAPFaultExceptionClient("Bad Request: Authenication failure.");
		}
		return retval;
	}

	@WebResult(name = "isChanged")
	public boolean changeFlagAppPswd(PasswordChange passwordChange) {
		boolean retval = true;
		try {
			SecurityContext<UserPrivilege> flagAppSecContext = userAuthorizationSession.createSystemContext(
					"FlagAppLogin", UserPrivilege.FLAG_APP_LOAD, UserPrivilege.CONNECT, UserPrivilege.CHANGE_PASSWORD);
			userAuthenticSession.connect(passwordChange.getUsername(), passwordChange.getPassword(), passwordChange.getNewPassword(), flagAppSecContext);
		} catch (SecuritySystemException e) {
			logr.log(Level.WARNING, "{0} failed a FLAG_APP password change/login - {1}: {2}", new Object[]{passwordChange.getUsername(), new Date(), e.getMessage()});
			retval = false;
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException.createSOAPFaultExceptionClient("Bad Request: Authenication failure.");
		}
		return retval;
	}

	@WebResult(name = "flagAppId")
	public long createFlagApp(FlagAppPayload flagAppPayload) {

		FlagApp flagApp = flagAppPayload.getFlagApp();
		if (flagApp == null) {
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException
					.createSOAPFaultExceptionClient("Illegal Argument: The FlagApp element cannnot be null.");
		}

		// Query CaseType by caseTypeCd provided by typeOfCase in FlagAppPayload object.
		LookupModelObjectsBean lookupCaseType = new LookupModelObjectsBean(lookupSession);
		String caseTypeCd = FlagApp.CASE_TYPE_CD;
		CaseType caseType = lookupCaseType.getCaseType(caseTypeCd);
		if (caseType == null) {
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException
					.createSOAPFaultExceptionClient("Bad Request: The CaseType could not be found by the provided typeOfCase element in the FlagAppPayload.xml.");
		}

		// Query SourceSystem by sourceSystemCd provided by sourceSystem in FlagAppPayload object.
		LookupModelObjectsBean lookupSourceSystem = new LookupModelObjectsBean(lookupSession);
		String sourceSystemCd = FlagApp.SOURCE_SYSTEM_CD;
		SourceSystem sourceSystem = lookupSourceSystem.getSourceSystem(sourceSystemCd);
		if (sourceSystem == null) {
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException
					.createSOAPFaultExceptionClient("Bad Request: The SourceSystem could not be found by the provided sourceSystem element in the FlagAppPayload.xml.");
		}

		// Query RegionalOffice by regionalOfficeNum provided by varo in FlagAppPayload object.
		System.out.println(FLAGAPP + ": Looking up regional office for office num:  " + flagApp.getRegionCd());
		LookupModelObjectsBean lookupRegionalOffice = new LookupModelObjectsBean(lookupSession);
		Integer regionalOfficeNum = flagApp.getRegionCd();
		RegionalOffice regionalOffice = lookupRegionalOffice
				.getRegionalOfficeByRegionalOfficeNum(regionalOfficeNum);
		if (regionalOffice == null) {
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException
					.createSOAPFaultExceptionClient("Bad Request: The RegionalOffice could not be found by the provided varo element in the FlagAppPayload.xml.");
		}
		System.out.println(FLAGAPP + ": Done Looking up regional office for office num:  " + flagApp.getRegionCd());
		
		
		// Upload to Document Storage and add docStorageId to FlagApp object.
		System.out.println(FLAGAPP + ": Uploading flagapp document " + flagAppPayload.getFlagApp().getFileName());
		FnodDocStorage fnodDocStorage = new FnodDocStorage(documentStorageSession);
		fnodDocStorage.uploadDocument(flagAppPayload);
		System.out.println(FLAGAPP + ": Done Uploading flagapp document " + flagAppPayload.getFlagApp().getFileName());
		

		// Create FNOD Model Objects
		System.out.println(FLAGAPP + ": Creating case link object ");
		FlagAppPayloadModelMapping flagAppPayloadModelMapping = new FlagAppPayloadModelMapping();
		CaseLink caseLink = flagAppPayloadModelMapping.mapFlagAppToModel(flagAppPayload, caseType, sourceSystem,
				regionalOffice);
		System.out.println(FLAGAPP + ": Done Creating case link object " );
		

		// Save FNOD Flag Case
		System.out.println(FLAGAPP + ": Saving flag app object ");
		long flagCaseId = caseSession.addPendingCase(caseLink);
		System.out.println(FLAGAPP + ": Done Saving flag app object, new case id: " + flagCaseId);
		if (flagCaseId == 0) {
			System.out.println(FLAGAPP + ": Failed at Saving flag app object..");
			
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException
					.createSOAPFaultExceptionClient("Internal Server: The FNOD Flag App Case could not be created.");
		}

		return flagCaseId;

	}

}
