package gov.va.fnod.soa_web.ws;

import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import gov.va.fnod.model.fnoddata.CaseData;
import gov.va.fnod.model.fnoddata.CaseFlagApp;
import gov.va.fnod.model.fnoddata.CaseLink;
import gov.va.fnod.model.fnoddata.CaseType;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.model.fnoddata.SourceSystem;
import gov.va.fnod.soa_common.model.flagapp.FlagApp;
import gov.va.fnod.soa_common.model.flagapp.FlagAppPayload;
import gov.va.fnod.soa_web.util.FnodPayloadModelMappingHelper;

public class FlagAppPayloadModelMapping {
	
	public FlagAppPayloadModelMapping() {
		
	}
	
	public CaseLink mapFlagAppToModel(FlagAppPayload flagAppPayload, CaseType caseType, 
		SourceSystem sourceSystem, RegionalOffice regionalOffice) {
		
		Timestamp loadDate = new Timestamp(new Date().getTime());
		
		// Create new CaseLink
		CaseLink caseLink = new CaseLink();
		caseLink.setCaseType(caseType);
		caseLink.setSourceSystem(sourceSystem);
		caseLink.setSrcTable("F"); // What is the source table info come from???
		caseLink.setLoadDate(loadDate);
		
		// Create new Case Flag APp
		FlagApp flagApp = flagAppPayload.getFlagApp();
		CaseFlagApp caseFlagApp = new CaseFlagApp();
		
		caseFlagApp.setCaseLink(caseLink);
		caseFlagApp.setEntryDt(loadDate);
		
		caseFlagApp.setRegionalId(regionalOffice.getRegion().getRegionId());
		caseFlagApp.setRegionalOfficeId(regionalOffice.getRegionalOfficeId());
		
		caseFlagApp.setScanProcessDt(flagApp.getScanProcessDt() == null ? null : new Timestamp(flagApp.getScanProcessDt().toGregorianCalendar().getTime().getTime()));
		
		
		caseFlagApp.setScanBatchId(flagApp.getScanBatchId()); 
		caseFlagApp.setScanBatchDt(flagApp.getScanBatchDt() == null ? null : new Timestamp(flagApp.getScanBatchDt().toGregorianCalendar().getTime().getTime()));
		
		caseFlagApp.setScanDocId(flagApp.getScanDocId());
		caseFlagApp.setScanDocDt(flagApp.getScanDocDt() == null ? null : new Timestamp(flagApp.getScanDocDt().toGregorianCalendar().getTime().getTime()));
		
		caseFlagApp.setDocStorageId(flagApp.getDocStorageId());
		
		caseLink.setCaseFlagApp(caseFlagApp);
		
		
		return caseLink;
	}
	

}
