package gov.va.fnod.soa_web.util;
import gov.va.fnod.model.fnoddata.CaseAddress;
import gov.va.fnod.model.fnoddata.CaseData;
import gov.va.fnod.model.fnoddata.CaseInsurance;
import gov.va.fnod.model.fnoddata.Person;
import gov.va.fnod.soa_common.model.fnod.Insurance;
import gov.va.fnod.soa_common.model.fnod.PersonName;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
public class FnodPayloadModelMappingHelper {

	
	public static String ParseStateNameFromString(String cityStateStr) { 
		if(cityStateStr != null) { 
			String [] strArr = cityStateStr.split("\\s+");
			return strArr[strArr.length-1];
		} else { 
			return "";
		}
	}
	
	public static String ParseCityNameFromString(String cityStateStr) { 
		
		StringBuffer sb = new StringBuffer();
		
		if(cityStateStr != null)  { 
			String [] strArr = cityStateStr.split("\\s+");

			for(int x = 0; (x <= strArr.length -2); x++ )  { 
				if(x == strArr.length-2) { 
					sb.append(strArr[x]);
				} else { 
					sb.append(strArr[x] + " ");
				}
			}
		}
		return sb.toString();
	}
	
	public static gov.va.fnod.model.fnoddata.Person CreateVeteranRecordFromInsuranceRecord(CaseInsurance ci) { 
		DateFormat format = new SimpleDateFormat("MM/dd/yyyy");
		
		gov.va.fnod.model.fnoddata.Person vet = new Person();
		PersonName personNm = CreatePersonNameFromCaseInsName(ci.getVeteranName());
		vet.setSocialSecurityNumber(ci.getVeteranSocialSecurityNumber());
		try { 
			vet.setBirthDt(format.parse(ci.getVeteranDateOfBirth()));
			vet.setDeathDt(format.parse(ci.getVeteranDateOfDeath()));
		} catch(ParseException pe) { 
			System.out.println("Date Parse Exception: " + pe.getMessage());
			System.out.println(pe.getStackTrace());
		}
		vet.setFirstName(personNm.getFirstName());
		vet.setMiddleName(personNm.getMiddleName());
		vet.setLastName(personNm.getLastName());
		vet.setSuffixName(personNm.getSuffix());
		
		
		return vet;
	}
	
	public static gov.va.fnod.model.fnoddata.Person CreateSpouseRecordFromInsuranceRecord(CaseInsurance ci) { 
		PersonName personNm = CreatePersonNameFromCaseInsName(ci.getSpouseName());
		
		gov.va.fnod.model.fnoddata.Person spousePersonModel = new gov.va.fnod.model.fnoddata.Person();
		
		spousePersonModel.setFirstName(personNm.getFirstName());
		spousePersonModel.setMiddleName(personNm.getMiddleName());
		spousePersonModel.setLastName(personNm.getLastName());
		spousePersonModel.setSuffixName(personNm.getSuffix());
		
		
		return spousePersonModel;
	}
	
	public static CaseAddress CreateVeteranAddress(Insurance ins, CaseData cd, String addrType) { 
		CaseAddress veteranCaseAddressModel = new CaseAddress();
		veteranCaseAddressModel.setAddressType(addrType);
		gov.va.fnod.model.fnoddata.Address veteranAddressModel = new gov.va.fnod.model.fnoddata.Address();
		veteranAddressModel.setLine1(ins.getNameAndAddressLine1());
		veteranAddressModel.setLine2(ins.getNameAndAddressLine2());
		veteranAddressModel.setLine3(ins.getNameAndAddressLine3());
		veteranAddressModel.setLine4(ins.getNameAndAddressLine4());
		veteranAddressModel.setLine5(ins.getNameAndAddressLine5());
		veteranAddressModel.setCity(cd.getVeteranHomeOfRecordCity());
		veteranAddressModel.setStateProvCd(cd.getVeteranHomeOfRecordState());
		veteranAddressModel.setZipCode(ins.getZipOrForeignCode());
		
		veteranCaseAddressModel.setAddress(veteranAddressModel);
		return veteranCaseAddressModel;
	}
	
	public static CaseAddress CreateSpouseAddress(Insurance ins, CaseData cd, String addrType) { 
		CaseAddress caseAddressModel = new CaseAddress();
		caseAddressModel.setAddressType(addrType);
		gov.va.fnod.model.fnoddata.Address addressModel = new gov.va.fnod.model.fnoddata.Address();
		addressModel.setLine1(ins.getSpouseAddressLine1());
		addressModel.setLine2(ins.getSpouseAddressLine2());
		addressModel.setLine3(ins.getSpouseAddressLine3());
		
		addressModel.setCity(ParseCityNameFromString(ins.getSpouseCityAndState()));
		addressModel.setStateProvCd(ParseCityNameFromString(ins.getSpouseCityAndState()));
		addressModel.setZipCode(ins.getSpouseZip());
		
		caseAddressModel.setAddress(addressModel);
		return caseAddressModel;
	}
	
	public static PersonName CreatePersonNameFromCaseInsName(String vetName) { 
		PersonName vetPersonName = new PersonName();
		if(vetName == null || "".equals(vetName)) { 
			return vetPersonName;
		}
		String [] strArr = vetName.split("\\s+");
		boolean noSuffix = true;
		if( strArr.length == 2 ) { 
			// easy one
			vetPersonName.setFirstName(strArr[0]);
			vetPersonName.setLastName(strArr[1]);

		}else { 
			int lastElem = strArr.length-1;
			// hand a name with a suffix
			if( WebSrvcConstants.NM_SUFFIX_LST.contains(strArr[lastElem].toUpperCase() )) { 
				// we have a name suffix at the end
				vetPersonName.setSuffix(strArr[lastElem]);
				lastElem--;
				vetPersonName.setLastName(strArr[lastElem]);
				lastElem--;
				noSuffix = false;
			} 


			/*
			 * We have 2 or more elements left, so we need to figure out the pattern
			 * 
			 * See JUNIT test class FnodPayloadModelMappingHelperTest
			 * 
			 * Here are the patterns we are covering
			 * 
			 * 
			 * String name = "David White";
			 * String name = "David A White";
			 * String name = "David A R White";
			 * String name = "Rueben Von Stueben";
			 * String name = "Billy Bob Thorton";
			 * String name = "Rueben A Von Stueben";
			 * String name = "Billy Bob A Thorton";
			 * String name = "Rueben A Von Stueben Sr";
			 * String name = "Billy Bob A Thorton Jr";
			 * String name = "T J Thorton Jr";
			 * String name = "Red Baron Manfred T J Von Richthofen Jr";
			 * 
			 */
			if( noSuffix ) { 
				vetPersonName.setLastName(strArr[lastElem--]);
			}

			if( lastElem == 1 && strArr[lastElem].length() == 1 ) { 
				// we have a middle and first name left 
				vetPersonName.setMiddleName(strArr[lastElem--]);
				vetPersonName.setFirstName(strArr[lastElem--]);
			}else if( lastElem == 1 && strArr[lastElem].length() > 1 && !WebSrvcConstants.COMMON_3_LTR_NAMES.contains(strArr[lastElem].toLowerCase()))  {  
				// have a complex last name, Von Stueben, Mc Nally etc
				vetPersonName.setLastName(strArr[lastElem--] + " " + vetPersonName.getLastName());
				vetPersonName.setFirstName(strArr[lastElem]);
			}else if( lastElem == 1 && strArr[lastElem].length() > 1 && WebSrvcConstants.COMMON_3_LTR_NAMES.contains(strArr[lastElem].toLowerCase()))  {  
				// have a complex first name, Bill Bob Thorton
				vetPersonName.setFirstName( strArr[lastElem -1] + " " +  strArr[lastElem]);
			}else if(lastElem >= 2 ) { // we still have 3 or more parts left  

				for ( int x = lastElem; x > -1; x--) { 
					// if last element > 1, we have a complex last name again, and other more complex name
					if( strArr[x].length() > 1  && x == lastElem) { 
						vetPersonName.setLastName(strArr[x] + " " + vetPersonName.getLastName() );
					} else if( strArr[x].length() == 1 && vetPersonName.getMiddleName() == null) { 
						// check for complex middle names like David A R White
						vetPersonName.setMiddleName(strArr[x]);
					} else if( x >= 1 && strArr[x].length() == 1 && vetPersonName.getMiddleName() != null ) {
						// check for complex middle names like David A R White
						vetPersonName.setMiddleName(strArr[x] + " " + vetPersonName.getMiddleName());
					} else if( x == 1  && strArr[x].length() > 1 && strArr[x-1].length() > 1 ) {
						// we have a complex first name like Mary Ann or Billy Bob
						vetPersonName.setFirstName(strArr[x-1] + " " + strArr[x]);
						x--;
					}else if( x == 0 ) { 
						vetPersonName.setFirstName(strArr[x]);
					}else { 
						// we got some crazy first name, so we are just going to append together
						// Red Baron Manfred T J Von Richthofen Jr
						for( int i = x; i > -1; i--) { 
							if( i > 0  && vetPersonName.getFirstName() == null) { 
								vetPersonName.setFirstName(" " + strArr[i]);
							} else if( i > 0 ) {  
								vetPersonName.setFirstName(" " + strArr[i] + vetPersonName.getFirstName());	
							}else { 
								vetPersonName.setFirstName(strArr[i] + vetPersonName.getFirstName());
							}

						}
						lastElem = -1;
						x = -1;
					}
				}

			}

		}

		
		return vetPersonName;
	}
	/*
	 * TODO: Create Veteran
	 * 		Create VeteranPerson
	 * 
	 * 
	 */
	
	
}
