package gov.va.fnod.soa_web.exception;
import javax.ejb.EJB;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;

import org.apache.log4j.Logger;

@EJB
public class CustomSOAPFaultException {
	
	private static Logger log = Logger.getLogger(CustomSOAPFaultException.class);
	
	public CustomSOAPFaultException()  {
		
	}
	
	public void createSOAPFaultExceptionClient(String errorMessage) {
		
		try {
			SOAPFactory soapFactory = SOAPFactory.newInstance();
			SOAPFault soapFault = soapFactory.createFault(errorMessage, new QName(
					SOAPConstants.URI_NS_SOAP_1_1_ENVELOPE, "Client"));
			log.error(new SOAPFaultException(soapFault).fillInStackTrace());
			throw new SOAPFaultException(soapFault);
		} catch (SOAPException e) {
			log.error(e.getMessage(),e.fillInStackTrace());
			throw new RuntimeException(e);
		}
		
	}
	
	public void createSOAPFaultExceptionServer(String errorMessage) {
		
		try {
			SOAPFactory soapFactory = SOAPFactory.newInstance();
			SOAPFault soapFault = soapFactory.createFault(errorMessage, new QName(
					SOAPConstants.URI_NS_SOAP_1_1_ENVELOPE, "Server"));
			log.error(new SOAPFaultException(soapFault), new SOAPFaultException(soapFault).fillInStackTrace());
			throw new SOAPFaultException(soapFault);
		} catch (SOAPException e) {
			log.error(e.getMessage(),e.fillInStackTrace());
			throw new RuntimeException(e);
		}
		
	}

}
