package gov.va.fnod.soa_common.service;

import gov.va.fnod.soa_common.model.fnod.Address;
import gov.va.fnod.soa_common.model.fnod.CaseTypeCd;
import gov.va.fnod.soa_common.model.fnod.Cemetery;
import gov.va.fnod.soa_common.model.fnod.Decedent;
import gov.va.fnod.soa_common.model.fnod.Fnod;
import gov.va.fnod.soa_common.model.fnod.FnodCase;
import gov.va.fnod.soa_common.model.fnod.FnodPayload;
import gov.va.fnod.soa_common.model.fnod.Person;
import gov.va.fnod.soa_common.model.fnod.PersonName;
import gov.va.fnod.soa_common.model.fnod.Relationship;
import gov.va.fnod.soa_common.model.fnod.SourceSystemCd;
import gov.va.fnod.soa_common.model.fnod.Veteran;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.junit.Test;

public class FnodClientServiceBeanTest extends AbstractJUnitTests {
	

	@Test
	public void testMarshallFnodCase() throws ParseException {
		PersonName decedentPersonName = new PersonName();
		decedentPersonName.setFirstName(DECEDENT_FIRST_NAME);
		decedentPersonName.setMiddleName(DECEDENT_MIDDLE_NAME);
		decedentPersonName.setLastName(DECEDENT_LAST_NAME);
		decedentPersonName.setSuffix(DECEDENT_SUFFIX);
		Person decedentPerson = new Person();
		decedentPerson.setName(decedentPersonName);
		decedentPerson.setSocialSecurityNumber(DECEDENT_SOCIAL_SECURITY_NUMBER);
		decedentPerson.setDecedentId(DECEDENT_DECEDENT_ID);
//		decedentPerson.setDateOfBirth(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(DECEDENT_DATE_OF_BIRTH));
//		decedentPerson.setDateOfDeath(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(DECEDENT_DATE_OF_DEATH));
//		decedentPerson.setDateOfInterment(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(DECEDENT_DATE_OF_INTERMENT));
		Address dependentAddress = new Address();
		dependentAddress.setLine1(DECEDENT_ADDRESS_LINE_1);
		dependentAddress.setLine2(DECEDENT_ADDRESS_LINE_2);
		dependentAddress.setLine3(DECEDENT_ADDRESS_LINE_3);
		dependentAddress.setLine4(DECEDENT_ADDRESS_LINE_4);
		dependentAddress.setCity(DECEDENT_CITY);
		dependentAddress.setPostalCode(DECEDENT_POSTAL_CODE);
		dependentAddress.setStateOrProvidence(DECEDENT_STATE_PROVIDENCE);
		dependentAddress.setForeignMailCode(DECEDENT_FOREIGN_MAIL_CODE);
		Decedent decedent = new Decedent();
		decedent.setRelationship(Relationship.SPOUSE);
		decedent.setPerson(decedentPerson);
		decedent.setAddress(dependentAddress);
		PersonName veteranPersonName = new PersonName();
		veteranPersonName.setFirstName(VETERAN_FIRST_NAME);
		veteranPersonName.setMiddleName(VETERAN_MIDDLE_NAME);
		veteranPersonName.setLastName(VETERAN_LAST_NAME);
		veteranPersonName.setSuffix(VETERAN_SUFFIX);
		Person veteranPerson = new Person();
		veteranPerson.setName(veteranPersonName);
		veteranPerson.setSocialSecurityNumber(VETERAN_SOCIAL_SECURITY_NUMBER);
		veteranPerson.setDecedentId(VETERAN_DECEDENT_ID);
//		veteranPerson.setDateOfBirth(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(VETERAN_DATE_OF_BIRTH));
//		veteranPerson.setDateOfDeath(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(VETERAN_DATE_OF_DEATH));
//		veteranPerson.setDateOfInterment(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(VETERAN_DATE_OF_INTERMENT));
		Address veteranAddress = new Address();
		veteranAddress.setLine1(VETERAN_ADDRESS_LINE_1);
		veteranAddress.setLine2(VETERAN_ADDRESS_LINE_2);
		veteranAddress.setLine3(VETERAN_ADDRESS_LINE_3);
		veteranAddress.setLine4(VETERAN_ADDRESS_LINE_4);
		veteranAddress.setCity(VETERAN_CITY);
		veteranAddress.setPostalCode(VETERAN_POSTAL_CODE);
		veteranAddress.setStateOrProvidence(VETERAN_STATE_PROVIDENCE);
		veteranAddress.setForeignMailCode(VETERAN_FOREIGN_MAIL_CODE);
		Cemetery cemetery = new Cemetery();
		cemetery.setNumber(CEMETERY_NUMBER);
		cemetery.setName(CEMETERY_NAME);
		cemetery.setType(CEMETERY_TYPE);
		Veteran veteran = new Veteran();
		veteran.setPerson(veteranPerson);
		veteran.setAddress(veteranAddress);
		veteran.setCemetery(cemetery);
		veteran.setAliasLastName(VETERAN_ALIAS_LAST_NAME);
		veteran.setServiceNumber(VETERAN_SERVICE_NUMBER);
		veteran.setBranchOfService(VETERAN_BRANCH_OF_SERVICE);
		veteran.setRank(VETERAN_RANK);
//		veteran.setEnteredOnActiveDutyDate(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(VETERAN_ENTERED_ON_ACTIVE_DUTY_DATE));
//		veteran.setReleasedFromActiveDutyDate(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(VETERAN_RELEASED_FROM_ACTIVE_DUTY_DATE));
		veteran.setWarPeriod(VETERAN_WAR_PERIOD);
		veteran.setClaimNumber(VETERAN_CLAIM_NUMBER);
		veteran.setVeteranId(VETERAN_ID);
		Fnod fnod = new Fnod();
		fnod.setCityHomeOfRecord(CITY_HOME_OF_RECORD);
		fnod.setStateHomeOfRecored(STATE_HOME_OF_RECORD);
		fnod.setVeteran(veteran);
		fnod.setDecedent(decedent);
		FnodCase fnodCase = new FnodCase();
//		fnodCase.setReportedDate(new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY).parse(REPORTED_DATE));
		fnodCase.setCaseTypeCd(CaseTypeCd.FNOD);
		fnodCase.setSourceSystemCd(SourceSystemCd.AMAS);
		fnodCase.setUserId(USER_ID);
		fnodCase.setFnod(fnod);
		FnodPayload fnodPayload = new FnodPayload();
		fnodPayload.setFnodCase(fnodCase);
		FnodClientServiceBean getFnodXml = new FnodClientServiceBean();
		// Would like to compare xml from InputStream to FnodXMLSchema.xml
	}
	
	/*@Test
	public void testGetFnodCaseId() {
		ClientResponse clientResponse = new ClientResponse(0, null, null, null);
		clientResponse.setStatus(201);
		InputStream is = new ByteArrayInputStream(FNOD_CASE_RESPONSE_XML.getBytes());
		clientResponse.setEntityInputStream(is);
		FnodClientServiceBean getFnodCaseId = new FnodClientServiceBean();
		long fnodCaseId = getFnodCaseId.getFnodCaseId(clientResponse);
		assertEquals(fnodCaseId, 1001);
	}*/

}
