package gov.va.fnod.soa_common.service;

import gov.va.fnod.soa_common.fnodcaseservice.FnodPayloadService;
import gov.va.fnod.soa_common.fnodcaseservice.FnodPayloadService_Service;
import gov.va.fnod.soa_common.model.ServiceConnectionParams;
import gov.va.fnod.soa_common.model.fnod.Authentication;
import gov.va.fnod.soa_common.model.fnod.FnodPayload;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

import org.apache.log4j.Logger;

/**
 * 
 * @author vhaisfkneelc
 * 
 *
 */

public class FnodClientServiceBean implements FnodClientService {

	private static Logger log = Logger.getLogger(FnodClientServiceBean.class);

	public FnodClientServiceBean() {

	}

	public long submit(FnodPayload fnodPayload,
			ServiceConnectionParams serviceConnectionParams) {
		log.debug("In " + this.getClass().toString()  + ".submit");
		Authentication authentication = new Authentication();

		authentication.setUsername(serviceConnectionParams.getUsername());

		authentication.setPassword(serviceConnectionParams.getPassword());

		fnodPayload.getFnodCase().setAuthentication(authentication);

		String endpoint = serviceConnectionParams.getEndpoint();

		long fnodCaseId = 0;
		String servername = "http://fnodcaseservice.fnod.domain";

		try {

			URL url = new URL(endpoint + "?wsdl");

			QName qname = new QName(servername, "FnodPayloadService");

			// FnodPayloadService service = new FnodPayloadService(); //
			// .create(url, qname);

			FnodPayloadService_Service service = new FnodPayloadService_Service();

			// gov.va.fnod.soa_common.fnodcaseservice.FnodPayload fnod =
			// service.getPort(new QName(servername, "FnodPayload"),
			// gov.va.fnod.soa_common.fnodcaseservice.FnodPayload.class);
			FnodPayloadService fnod = service.getFnodPayload(); // (new
																// QName(servername,
																// "FnodPayload"),
																// gov.va.fnod.soa_common.fnodcaseservice.FnodPayload.class);

			fnodCaseId = fnod.createFnodCase(fnodPayload);
			log.debug("New FNOD Case ID: " + fnodCaseId);

		} catch (MalformedURLException e) {

			log.error(e.getMessage(), e.fillInStackTrace());

			throw new RuntimeException(
					"A serious failure occured when trying to create the new FNOD case.");

		} catch (SOAPFaultException e) {

			log.error(e.getMessage(), e.fillInStackTrace());

			throw new RuntimeException(
					"A serious failure occured when trying to create the new FNOD case.");

		} catch (WebServiceException e) {

			log.error(e.getMessage(), e.fillInStackTrace());

			throw new RuntimeException(
					"A serious failure occured when trying to create the new FNOD case.");

		} catch (Exception e) {

			log.error(e.getMessage(), e.fillInStackTrace());

			throw new RuntimeException(
					"A serious failure occured when trying to create the new FNOD case.");

		}

		return fnodCaseId;

	}

}
