/**
 * 
 */
package gov.va.fnod.soa_common.service;


import gov.va.fnod.soa_common.model.ServiceConnectionParams;
import gov.va.fnod.soa_common.model.fnod.FnodPayload;

/**
 * The FNOD Client Service interface.
 * 
 * @author VHAISFKNEELC
 *
 */
public interface FnodClientService {
	
	/**
	 * Submits a new FNOD case that is either a {@link FnodCase} or a {@link Insurance} case. 
	 * Authentication is performed through the {@link gov.va.fnod.soa_common.model.fnod.Authentication} 
	 * object. The case is submitted through a SOAP client to the SOA web service. A successful 
	 * creation of a new case will return a long object of the new FNOD case ID.
	 * 
	 * @param fnodPayload The {@link FnodPayload} object.
	 * @param serviceConnectionParams The {@link ServiceConnectionParams} object.
	 * @return The created FNOD case ID.
	 */
	public long submit(FnodPayload fnodPayload, ServiceConnectionParams serviceConnectionParams);

}
