package gov.va.fnod.soa_common.service;

import gov.va.fnod.soa_common.flagappservice.FlagAppPayloadService;
import gov.va.fnod.soa_common.flagappservice.FlagAppPayloadService_Service;
import gov.va.fnod.soa_common.model.flagapp.Authentication;
import gov.va.fnod.soa_common.model.flagapp.FlagApp;
import gov.va.fnod.soa_common.model.flagapp.FlagAppPayload;
import gov.va.fnod.soa_common.model.flagapp.PasswordChange;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;


public class FlagClientServiceBean implements FlagClientService, FnodWSConstants {
	
	private static Logger log = Logger.getLogger(FlagClientServiceBean.class);

	
	
	
	public boolean authFlagAppUser(String endpoint, Authentication authentication) {
	
		boolean isAuth = false;
		
		try {
			FlagAppPayloadService flag = this.getFlagAppService(endpoint);
			isAuth = flag.authFlagAppUser(authentication);
		}  catch (SOAPFaultException e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL, e);
		} catch (WebServiceException e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL, e);
		} catch (Exception e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL, e);
		}
		
		return isAuth;
	}

	
	public long submit(String endpoint, FlagAppPayload flagAppPayload) {

		System.out.println("FLAG_APP: Starting submit");
		long flagAppId = 0;
		System.out.println("FLAG_APP: Getting Flag App From the payload" );
		FlagApp flagApp = flagAppPayload.getFlagApp();
		System.out.println("FLAG_APP: Getting PDF file");
		byte[] pdfBytes = flagApp.getPdfFile();
		System.out.println("FLAG_APP: Creating MD5 Hex Checksum");
		String md5Checksum =  DigestUtils.md5Hex(pdfBytes);
		System.out.println("FLAG_APP: Checksum = " + md5Checksum);
		
		System.out.println("FLAG_APP: Base 64 encoding");
		byte[]  pdfBase64 = Base64.encodeBase64(pdfBytes);
		System.out.println("FLAG_APP: Setting checksum");
		flagApp.setMd5Checksum(md5Checksum);
		System.out.println("FLAG_APP: Setting PDF file");
		flagApp.setPdfFile(pdfBase64);
		System.out.println("FLAG_APP: Applying changes to the payload");
		System.out.println("FLAG_APP: Applying changes to the payload");
		flagAppPayload.setFlagApp(flagApp);
		
		System.out.println("FLAG_APP: FlagApp Payload set... filename: " + flagApp.getFileName());
		log.info("FLAG_APP: FlagApp Payload set... filename: " + flagApp.getFileName());
		
		try {
			FlagAppPayloadService flag = this.getFlagAppService(endpoint);
			flagAppId = flag.createFlagApp(flagAppPayload);
			System.out.println("FLAG_APP: NEW FlagApp ID:" + flagAppId);
			log.info("FLAG_APP: NEW FlagApp ID:" + flagAppId);
			
			
		} catch (SOAPFaultException e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL_APP);
		} catch (WebServiceException e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL_APP);
		} catch (Exception e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL_APP);
		}	
		
		return flagAppId;
	}

	
	public boolean changeFlagAppPswd(String endpoint, PasswordChange passwordChange) {
		boolean retval = false;
		
		try {
			FlagAppPayloadService flag = this.getFlagAppService(endpoint);
			retval = flag.changeFlagAppPswd(passwordChange);
		}  catch (SOAPFaultException e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL, e);
		} catch (WebServiceException e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL, e);
		} catch (Exception e) {
			log.error(e.getMessage(), e.fillInStackTrace());
			throw new RuntimeException(FAIL, e);
		}
		
		return retval;
	}
	
	/**
	 * consolidated way to get load the FlagApp Service
	 * @return a handle to the flagappservice
	 */
	private FlagAppPayloadService getFlagAppService(String endpoint){
		
		
		FlagAppPayloadService_Service service = null;
		try {
			service = new FlagAppPayloadService_Service(new URL(endpoint + "?wsdl"), new QName("http://flagappservice.fnod.domain", "FlagAppPayloadService"));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return service.getFlagAppPayload();
	}

}
