package gov.va.fnod.soa_common.service;



import gov.va.fnod.soa_common.model.ServiceConnectionParams;

import gov.va.fnod.soa_common.model.flagapp.Authentication;

import gov.va.fnod.soa_common.model.flagapp.FlagAppPayload;

import gov.va.fnod.soa_common.model.flagapp.PasswordChange;



/**

 * The Flag Application Client interface.

 * 

 * @author VHAISFKNEELC

 *

 */

public interface FlagClientService {

	

	/**

	 * Authenticates a user for the Flag Application. Authentication is performed through the 

	 * {@link gov.gov.va.fnod.soa_common.model.fnod.flag.Authentication} object. 

	 * Returns true if the user is authorized in the system and false if the user is not authorized.

	 * 

	 * @param flagAppPayload The {@link FlagAppPayload} object.

	 * @param serviceConnectionParams The {@link ServiceConnectionParams} object.

	 * @return boolean.

	 */

	public boolean authFlagAppUser(String endpoint, Authentication authentication);

	

	/**

	 * Authenticates a user for the Flag Application and if confirmed changes the password to the newly supplied

	 * through the {@link gov.gov.va.fnod.soa_common.model.fnod.flag.Authentication authentication} object. 

	 * 

	 * @param flagAppPayload

	 * @param serviceConnectionParams

	 * @return

	 */

	public boolean changeFlagAppPswd(String endpoint, PasswordChange passwordChange);

	

	/**

	 * Submits a new Flag Application. Creates a md5 checksum of the PDF byte array for checking if the file 

	 * array gets corrupted in transit. Also Base64's the PDF byte array before submitting. 

	 * The flag app is submitted through a SOAP client to the SOA web service. A successful creation of a 

	 * new flag app case will return a long object of the new Flag App case ID.

	 * 

	 * @param flagAppPayload The {@link FlagAppPayload} object.

	 * @param serviceConnectionParams The {@link ServiceConnectionParams} object.

	 * @return long object.

	 */

	public long submit(String endpoint, FlagAppPayload flagAppPayload);



}

