package gov.va.fnod.security;



import gov.va.fnod.security.authorization.UserContext;

import gov.va.fnod.security.service.PswdHasherFactoryTestHelper;

import junit.framework.Assert;



import org.junit.AfterClass;

import org.junit.BeforeClass;

import org.junit.Test;



public class PswdHelperTest {

	

	@BeforeClass

	public static void beforeClass() {

		PswdHasherFactoryTestHelper.register(new GenericPswdHash());

	}

	

	@AfterClass

	public static void afterClass() {

		PswdHasherFactoryTestHelper.clear();

	}



	@Test

	public void pswdMatchTestTrue() {

		

		UserContext context = getContext(1,"ROOT");

		String pswd = "ThisIsATestPassword";

		

		String hashedValue = PswdHelper.hashPassword(context, pswd);

		

		Assert.assertTrue("pswdMatch should have returned true",PswdHelper.pswdMatch(context, pswd, hashedValue));

	}

	

	@Test

	public void pswdMatchTestFalse() {

		

		UserContext context = getContext(1,"ROOT");

		String pswd = "ThisIsATestPassword";

		String badPswd = "ThisIsABadPassword";

		

		String hashedValue = PswdHelper.hashPassword(context, pswd);

		

		Assert.assertFalse("pswdMatch should have returned false",PswdHelper.pswdMatch(context, badPswd, hashedValue));

		

	}

	

	private UserContext getContext(final long id, final String username) {

		return new UserContext() {



			@Override

			public String getUserName() {				

				return username;

			}



			@Override

			public long getUserId() {

				return id;

			}};

	}

}

