package gov.va.fnod.security;

import gov.va.fnod.security.authentication.PswdHashInterface;

import org.junit.Assert;
import org.junit.Test;

public abstract class PswdHashInterfaceTest<H extends PswdHashInterface> {
	
	protected abstract H getHasher();
	
	/**
	 * Given the same password, the hasher must return different hashed values.
	 */
	@Test
	public void uniqueHashTest() {
		String password = "ThisIsATestPassword";
		
		String pass1 = getHasher().hashValue(password);
		String pass2 = getHasher().hashValue(password);
		
		Assert.assertTrue("Different hashedValues expected; values are equal", !pass1.equals(pass2));
	}
	
	/**
	 * If a hash is generated with a known seed, the same seed
	 * must be returned from extract seed.
	 */
	@Test
	public void extractSeedTest() {
		String password = "ThisIsADifferentTestPassword";
		long seed = 2001;
		
		String hashedValue = getHasher().hashValue(password, seed);
		
		Assert.assertEquals(seed, getHasher().extractSeed(hashedValue));
	}
	
	/*
	 * Hashing the same password twice using the same seed must return
	 * the same hash value;
	 */
	@Test
	public void hashValueWithSeed() {
		String password = "ThisIsYetAnotherPassword";
		long seed = -123123123L;
		
		String hashedValue = getHasher().hashValue(password, seed);
		
		Assert.assertEquals(hashedValue, getHasher().hashValue(password,seed));
	}
	/**
	 * If we have a token and a hashedValue generated from the same token,
	 * tokesEqual must return true.
	 */
	@Test
	public void tokensEqualTest() {
		
		String token = "ThisIsATokenTestPassword";
		String hashedValue = getHasher().hashValue(token);
		
		Assert.assertTrue("tokensEqual expected to return true",getHasher().tokensEqual(token, hashedValue));
	}
	
	/*
	 * If we have token, and hashValue generated from a different token, then
	 * tokensEqual must return false.
	 */
	@Test
	public void tokensNotEqual() {
		String token = "ThisIsATokenTestPassword";
		String differentToken = "ThisIsADifferentToken";
		
		String hashedValue = getHasher().hashValue(token);
		
		Assert.assertFalse("tokensEqual expected to return false",getHasher().tokensEqual(differentToken, hashedValue));
	}
	
}
