package gov.va.fnod.security.service;



import gov.va.fnod.security.authorization.AppRole;



public class UserContextServiceFactory {



	private static final UserContextServiceFactory factory;

	static {

		factory = new UserContextServiceFactory();

	}



	private UserContextServiceFactory() {

		super();

	}



	static public UserContextServiceFactory getFactory() {

		return factory;

	}



	private UserContextService<? extends AppRole<?>> userContext;



	public synchronized <R extends AppRole<?>> void register(

			UserContextService<R> userContext) {



		if (userContext == null) {

			throw new IllegalArgumentException(

					"userContextService cannot be null");

		}



		if (this.userContext != null) {

			throw new IllegalStateException(

					"Cannot register more than one hasher");

		}



		this.userContext = userContext;



	}



	public synchronized UserContextService<? extends AppRole<?>> userContextService() {



		if (this.userContext == null) {

			throw new IllegalStateException("User Context Service not registered");

		}

		return this.userContext;



	}



	synchronized void clear() {

		this.userContext = null;

	}



}

