package gov.va.fnod.security.service;



import gov.va.fnod.security.authentication.UserInitialContext;

import gov.va.fnod.security.authentication.UserPswdChangeContext;

import gov.va.fnod.security.authorization.AppRole;

import gov.va.fnod.security.authorization.UserContext;

import gov.va.fnod.security.authorization.UserRoleContext;



public interface UserContextService<R extends AppRole<?> >  {

	

	public UserInitialContext getUserContext(String username);

	public UserRoleContext<R> getUserRoleContext(UserContext context);

	

	public UserPswdChangeContext getUserPswdChangeContext(UserContext context);

	

	public void save(UserPswdChangeContext context);

	public void save(UserInitialContext context);

	

}

