package gov.va.fnod.security.service;

import gov.va.fnod.security.authorization.AppPrivilege;
import gov.va.fnod.security.authorization.AppRole;

public class SystemContextServiceFactory {

	private static SystemContextServiceFactory factory;

	static {
		factory = new SystemContextServiceFactory();
	}

	private SystemContextService<? extends AppRole<?>, ? extends AppPrivilege<?>> service;

	private SystemContextServiceFactory() {
		super();
	}

	public static SystemContextServiceFactory getFactory() {
		return factory;
	}

	public <R extends AppRole<?>, P extends AppPrivilege<?>> void register(
			SystemContextService<R, P> service) {

		if (service == null) {
			throw new IllegalArgumentException("service cannot be null");
		}
		
		synchronized (SystemContextServiceFactory.factory) {
			if (this.service != null) {
				throw new IllegalStateException("service already registered");
			}
			this.service = service;
		}

	}

	public SystemContextService<? extends AppRole<?>, ? extends AppPrivilege<?>> getService() {

		synchronized (SystemContextServiceFactory.factory) {
			if (service == null) {
				throw new IllegalStateException(
						"SystemContextService not registered");
			}
			return service;
		}



	}

}
