package gov.va.fnod.security.service;



import gov.va.fnod.security.authentication.LoginConstraints;

import gov.va.fnod.security.authorization.AppPrivilege;

import gov.va.fnod.security.authorization.AppRole;

import gov.va.fnod.security.authorization.SecurityContext;



import java.util.Map;

import java.util.Set;



public interface SystemContextService<R extends AppRole<?>, P extends AppPrivilege<?>> {



	/**

	 * Provides system constraints needed to properly restrict password values.

	 * 

	 * @return

	 */

	public PswdChangeConstraints getPswdConstraints();



	/**

	 * Provides system constraints used to restrict user login.

	 * 

	 * @return

	 */

	public LoginConstraints getLoginConstraints();



	/**

	 * Provides a mapping of system roles to system privileges used 

	 * in authorization processes.

	 * 

	 * @return map of Roles to Privileges

	 */

	public Map<R, Set<P>> getRolePrivMap();



	/**

	 * Provides minimum list of privileges required to allow a user

	 * to login to the application.

	 * 

	 * @return

	 */

	public SecurityContext<P> getCanLoginContext();



	/**

	 * Provides minimum list of privileges required to allow a user

	 * to connect remotely to the application (like via web services).

	 * 

	 * @return

	 */

	public SecurityContext<P> getCanConnectContext();



	/**

	 * Provides minimum list of privileges required to allow an account

	 * to change its own password.

	 * 

	 * @return

	 */

	public SecurityContext<P> getCanChangePswdContext();



	/**

	 * Provides minimum list of privileges required to allow an account

	 * to change another accounts password.

	 * 

	 * @return

	 */

	public SecurityContext<P> getCanResetPswdContext();



	/**

	 * Provides minimum list of privileges required to allow an account

	 * to lock/unlock other accounts.

	 * 

	 * @return

	 */

	public SecurityContext<P> getCanLockUserContext();



}

