package gov.va.fnod.security.service;



import gov.va.fnod.security.authentication.PswdValidateComplexityInterface;

import gov.va.fnod.security.authentication.PswdValidateHistoryInterface;

import gov.va.fnod.security.authentication.PswdValidateLimitInterface;



/*

 * Provides password validators.

 */

public enum PswdValidatorFactory {

	

	INSTANCE;

	

	private PswdValidateLimitInterface limitValidator;

	private PswdValidateComplexityInterface complexityValidator;

	private PswdValidateHistoryInterface historyValidator;

	

	

	public static void register(PswdValidateLimitInterface limitValidator) {

		

		if ( limitValidator == null ) {

			throw new IllegalArgumentException("limitValidator cannot be null");

		}

		

		synchronized(INSTANCE) {

			if ( INSTANCE.limitValidator != null ) {

				throw new IllegalStateException();

			}

			INSTANCE.limitValidator = limitValidator;

		}

	}

	

	public static PswdValidateLimitInterface getLimitValidator() {

		

		synchronized(INSTANCE) {

			if ( INSTANCE.limitValidator == null ) {

				throw new IllegalStateException("limitValidator not registered");

			}			

			return INSTANCE.limitValidator;

		}

		

	}



	public static void register(PswdValidateComplexityInterface complexityValidator) {

		

		if ( complexityValidator == null ) {

			throw new IllegalArgumentException("complexityValidator cannot be null");

		}

		

		synchronized(INSTANCE) {

			if ( INSTANCE.complexityValidator != null ) {

				throw new IllegalStateException();

			}

			INSTANCE.complexityValidator = complexityValidator;

		}

	}

	

	public static PswdValidateComplexityInterface getComplexityValidator() {

		synchronized(INSTANCE) {

			if ( INSTANCE.complexityValidator == null ) {

				throw new IllegalStateException("complexityValidator not registered");

			}			

			return INSTANCE.complexityValidator;

		}		

	}



	public static void register(PswdValidateHistoryInterface historyValidator) {

		if ( historyValidator == null ) {

			throw new IllegalArgumentException("histroyValidator cannot be null");

		}

		

		synchronized(INSTANCE) {

			if ( INSTANCE.historyValidator != null ) {

				throw new IllegalStateException();

			}

			INSTANCE.historyValidator = historyValidator;

		}

	}

	

	public static PswdValidateHistoryInterface getHistoryValidator() {

		synchronized(INSTANCE) {

			if ( INSTANCE.historyValidator == null ) {

				throw new IllegalStateException("historyValidator not registered");

			}			

			return INSTANCE.historyValidator;

		}		

	}

		

	static synchronized void clear() {

		

		INSTANCE.limitValidator = null;

		INSTANCE.complexityValidator = null;

		INSTANCE.historyValidator = null;

		

	}	

	

}

