package gov.va.fnod.security.service;



import gov.va.fnod.security.authentication.PswdHashInterface;



/**

 * This is am implementation of a Factory Pattern used to allow for

 * a single point of configuration for the password hasher used through

 * out the application. 

 *   

 * @author Jim Lindelof

 *

 */

public enum PswdHasherFactory {

	

	INSTANCE;

	

	PswdHashInterface hasher;

	

	public static void registerHasher(PswdHashInterface hasher) {

	

		if ( hasher == null ) {

			throw new IllegalArgumentException("hasher cannot be null");

		}

		

		synchronized(INSTANCE) {

			if ( INSTANCE.hasher != null ) {

				throw new IllegalStateException("Cannot register more than one hasher");

			}

			INSTANCE.hasher = hasher;

		}

		

	}



	/**

	 * Returns the registered hasher; if one has been registered, an

	 * IllegalStateException will be thrown.

	 * @return

	 * @throws IllegalStateException if no hasher has been registered.

	 */

	public static PswdHashInterface getHasher() {

		synchronized(INSTANCE) {

			if ( INSTANCE.hasher == null ) {

				throw new IllegalStateException("no hasher registered");

			}

			return INSTANCE.hasher;

		}

	}

	

	/** 

	 * This method exists strictly for the support of unit testing.

	 */

	static void clear() {

		synchronized(INSTANCE) {

			INSTANCE.hasher = null;

		}

	}

}

