package gov.va.fnod.security.authorization;

import java.util.Set;

/**
 * A security event context used to explain to a
 * 
 * {@link AuthorizationAgent authorization agent} what permissions are required
 * to continue activity on the system.
 * 
 * @author Burk Price
 * @version 1.0 / 8-23-12
 */

public interface SecurityContext<P extends AppPrivilege<?>> {

    /**
     * Get the security context label
     * 
     * @return
     * @since 1.0
     */
    public String getContextLabel();

    /**
     * Get the {@link BaseUserPermissions permissions} that will allow use of
     * this security context.
     * 
     * Requests system for Role Privilege Map
     * 
     * @return
     * @since 1.0
     */
    public Set<P> requestPrivileges();

    /**
     * Get the {@link BaseUserPermissions permissions} that will exclude use of
     * this security context.
     * 
     * @return
     * @since 1.0
     */
    public Set<P> requestExclusionPrivileges();
}