package gov.va.fnod.security.authorization;

import gov.va.fnod.security.exception.AccountLockedException;

/**
 * 
 * Authorization agent to be queried during processes. This agent assumes that
 * the User has already been authenticated.
 * 
 * @author VHAISLPRICEB
 * 
 * @version 1.0 / 8-23-12
 */
public interface AuthorizationInterface {

    /**
     * 
     * Given the supplied requisite permission check to see if the user is authorized for continued activity
     * 
     * @param context
     * @param user
     * @return
     * @since 1.0
     */
    public <P extends AppPrivilege<?>> boolean isUserAuthorized(UserContext userContext, SecurityContext<P> sysContext) throws AccountLockedException;

   
}
