package gov.va.fnod.security.authentication;

import gov.va.fnod.security.LoginStatus;
import gov.va.fnod.security.authorization.UserContext;

import java.util.Date;
import java.util.List;

public interface UserPswdChangeContext extends UserContext {

	public String getPswdHash();

    public void setPswdHash(String pswdHash);

    public List<String> getPswdHistory();

    public void setPswdHistory(List<String> pswdHistory);

    public Date getLastPswdChangeDate();

    public void setLastPswdChangeDate(Date lastPswdChangeDate);

    public Date getExpiryDate();

    public void setExpiryDate(Date expiryDate);

    /**
    * @return
    */
    public LoginStatus getLoginStatus();

    /**
    * Needed to be able change LOCK_TIMEOUT to OPEN of successful
    * password reset/change.
    *
    * @param status
    */
    public void setLoginStatus(LoginStatus status);

    public Date getTimeLockedDate();

    /**
    * Needed to be able to change LOCKED_TIME to null on successful
    * password reset/change.
    * 
     * @param lockedDate
    */
    public void setTimeLockedDate(Date lockedDate);

}
