package gov.va.fnod.security.authentication;

import gov.va.fnod.security.exception.PswdLimitException;
import gov.va.fnod.security.service.PswdChangeConstraints;

public class PswdLimitsValidator implements PswdValidateLimitInterface {

	public PswdLimitsValidator() {
		super();		
	}
	
	
	public void validate(PswdChangeConstraints pswdChangeConstraints,
			UserPswdChangeContext context, String pswd)
			throws PswdLimitException {

		if (pswd == null
				|| pswd.length() < pswdChangeConstraints.getMinPswdLength()) {
			throw new PswdLimitException(String.format(
					"password must be at least %d characters long.",
					pswdChangeConstraints.getMinPswdLength()));
		}
		
		if ( pswd.length() > pswdChangeConstraints.getMaxPswdLength() ) {
			throw new PswdLimitException(String.format(
					"password may not be longer than %d characters.",
					pswdChangeConstraints.getMaxPswdLength()));
		}
		
		if ( ! pswd.matches(pswdChangeConstraints.getCharValidatingRegEx()) ) {
			throw new PswdLimitException("password contains invalid characters.");
		}

	}

}
