package gov.va.fnod.security.authentication;

import gov.va.fnod.security.PswdHelper;
import gov.va.fnod.security.exception.PswdHistoryException;

public class PswdHistoryValidator implements PswdValidateHistoryInterface {

	
	public void validate(UserPswdChangeContext context, String newPswd)
			throws PswdHistoryException {
		
		for( String hashedPswd: context.getPswdHistory() ) {
			if ( PswdHelper.pswdMatch(context, newPswd, hashedPswd) ) {
				throw new PswdHistoryException("password used too recently");
			}
		}
		
	}

}
