package gov.va.fnod.security.authentication;

/**
 * PswdHashable implementors are expected to hash passwords with a one way 
 * hash, adding a seed to ensure unique hashes are generated even if the 
 * same password is used. The applied seed must be added to the hash so that
 * it can be extracted later for password comparisons.
 * 
 * @author Jim Lindelof
 *
 */
public interface PswdHashInterface {
	
	/**
	 * Hashes the supplied password, generating the seed to be applied to the
	 * password - the resulting hash value will generated using both the 
	 * password and the seed value; the seed value must be able to be extracted
	 * from the resulting hash value. 
	 * 
	 * @param token - a string token used for authentication.
	 * @return a hashed value of the password with a generated seed value
	 */
	public String hashValue(String token);
	
	/**
	 * Hashes the supplied password, and seed - the resulting hash value will 
	 * be generated using both the password and the seed value; the seed value
	 * must be able to be extracted from the resulting hash value.
	 * 
	 * @param token
	 * @param seed
	 * @return
	 */
	public String hashValue(String token, long seed);
	
	/**
	 * Returns the seed value used in generating the given password hash.
	 * 
	 * @param hashedValue
	 * @return
	 */
	public long extractSeed(String hashedValue);
	
	/**
	 * Given two a token and a hashed value, return true if hasedValue represents
	 * token.
	 * 
	 * @param token
	 * @param hasedValue2
	 * @return
	 */
	public boolean tokensEqual(String token, String hashedValue);
		
}
