package gov.va.fnod.security.authentication;



import gov.va.fnod.security.authorization.AppPrivilege;

import gov.va.fnod.security.authorization.SecurityContext;

import gov.va.fnod.security.authorization.UserContext;

import gov.va.fnod.security.exception.AuthenticationException;

import gov.va.fnod.security.exception.AuthorizationException;

import gov.va.fnod.security.exception.PswdValidationException;



public interface AuthenticationInterface {



	public UserContext login(String username, String pswd)

			throws AuthenticationException;



	public UserContext login(String username, String oldPswd, String newPswd)

			throws AuthenticationException, AuthorizationException, PswdValidationException;



	public UserContext connect(String username, String pswd)

			throws AuthenticationException;



	public UserContext connect(String username, String pswd,

			SecurityContext<? extends AppPrivilege<?>> context)

			throws AuthenticationException;



	public UserContext connect(String username, String oldPswd, String newPswd)

			throws AuthenticationException, AuthorizationException, PswdValidationException;;



	public UserContext connect(String username, String oldPswd, String newPswd,

			SecurityContext<? extends AppPrivilege<?>> context)

			throws AuthenticationException, AuthorizationException, PswdValidationException;;



}

