package gov.va.fnod.security.authentication;



import gov.va.fnod.security.authorization.UserContext;

import gov.va.fnod.security.exception.AccountLockedException;

import gov.va.fnod.security.exception.AuthenticationException;

import gov.va.fnod.security.exception.AuthorizationException;

import gov.va.fnod.security.exception.PasswordTooNewException;

import gov.va.fnod.security.exception.PswdValidationException;



public interface AccountMaintenceInterface {



	/**

	 * This method is used to change the authenticated (current) users password.

	 * 

	 * @param curUser - logged in users context

	 * @param oldPswd - current password

	 * @param newPswd - desired new password

	 * @throws IllegalAccessException  - throw is user is not allowed to change password

	 * @throws PswdValidationException - password validation failed 

	 * @throws AccountLockedException 

	 * @throws PasswordTooNewException 

	 * @throws AuthorizationException 

	 */

	public void changePswd(UserContext curUser, String oldPswd, String newPswd ) 

			throws AuthenticationException, AuthorizationException, PswdValidationException;

	

	public void resetPswd(UserContext curUserContext, UserContext userContext, String pswd) 

			throws AuthorizationException, PswdValidationException;

	

	public void lockAccount(UserContext curUserContext, UserContext userContext) throws AuthorizationException;

	public void unLockAccount(UserContext curUserContext, UserContext userContext) throws AuthorizationException;

	

	public UserContext getUserContext(String username);

	

}

