package gov.va.fnod.security;

import gov.va.fnod.security.authorization.AppPrivilege;
import gov.va.fnod.security.authorization.SecurityContext;

import java.util.Collections;
import java.util.Set;


public class SecurityContextWrapper<P extends AppPrivilege<?> > implements SecurityContext<P> {

	private Set<P> requestPrivs = Collections.emptySet();
	private Set<P> exclusedPrivs = Collections.emptySet();
	private String contextLabel = "EMPTY_CONTEXT";
	
	
	public String getContextLabel() {
		return contextLabel;
	}

	public void setContextLabel(String value) {
		contextLabel = value;
	}
	
	
	public Set<P> requestPrivileges() {
		return requestPrivs;
	}

	
	public Set<P> requestExclusionPrivileges() {
		return exclusedPrivs;
	}
	
	public void setRequestPrivileges(Set<P> privs) {
		requestPrivs = privs;
	}
	
	public void setRequestExclusionPrivileges(Set<P> privs) {
		exclusedPrivs = privs;
	}
}
