package gov.va.fnod.security;



import gov.va.fnod.security.authentication.PswdHashInterface;

import gov.va.fnod.security.authentication.PswdHistoryValidator;

import gov.va.fnod.security.authentication.PswdLimitsValidator;

import gov.va.fnod.security.authentication.PswdValidateComplexityInterface;

import gov.va.fnod.security.authorization.AppPrivilege;

import gov.va.fnod.security.authorization.AppRole;

import gov.va.fnod.security.service.PswdHasherFactory;

import gov.va.fnod.security.service.PswdValidatorFactory;

import gov.va.fnod.security.service.SystemContextService;

import gov.va.fnod.security.service.SystemContextServiceFactory;

import gov.va.fnod.security.service.UserContextService;

import gov.va.fnod.security.service.UserContextServiceFactory;



import java.util.concurrent.TimeUnit;

import java.util.concurrent.locks.Lock;

import java.util.concurrent.locks.ReentrantLock;



public abstract class SecurityConfigUtility<R extends AppRole<?>, P extends AppPrivilege<?>> {



	private static Lock lock = new ReentrantLock();

	private static boolean initialized = false;



	public SecurityConfigUtility() {

		

		try {

			if ( lock.tryLock(1, TimeUnit.SECONDS) ) {

				try {

					if (!initialized) {

						PswdHasherFactory.registerHasher(getPswdHasher());

						

						PswdValidatorFactory

								.register(getPswdComplexityValidator());

						

						PswdValidatorFactory.register(new PswdLimitsValidator());

						PswdValidatorFactory.register(new PswdHistoryValidator());



						UserContextServiceFactory.getFactory().register(

								getUserContextService());

						

						SystemContextServiceFactory.getFactory().register(

								getSystemContextService());



						initialized = true;

						

						System.out.println("SecurityConfigUtility executed");

					}

				} finally {

					lock.unlock();

				}

			}

		} catch (InterruptedException ex) {

			// Preventing dead-lock

			// do nothing

		}

	}



	protected abstract PswdHashInterface getPswdHasher();



	protected abstract PswdValidateComplexityInterface getPswdComplexityValidator();



	protected abstract UserContextService<R> getUserContextService();



	protected abstract SystemContextService<R, P> getSystemContextService();



}

