package gov.va.fnod.security;



import gov.va.fnod.security.authentication.PswdValidateComplexityInterface;

import gov.va.fnod.security.authentication.PswdValidateHistoryInterface;

import gov.va.fnod.security.authentication.PswdValidateLimitInterface;

import gov.va.fnod.security.authentication.UserPswdChangeContext;

import gov.va.fnod.security.exception.PswdComplexityException;

import gov.va.fnod.security.exception.PswdHistoryException;

import gov.va.fnod.security.exception.PswdLimitException;

import gov.va.fnod.security.exception.PswdValidationException;

import gov.va.fnod.security.service.PswdChangeConstraints;

import gov.va.fnod.security.service.PswdValidatorFactory;

import gov.va.fnod.security.service.SystemContextServiceFactory;



final class PswdValidatorUtility {

		

	public PswdValidatorUtility() {

		super();

	}

	

	public void validate( UserPswdChangeContext userPswdContext, String pswd ) throws PswdValidationException {



		doLimitsValidation(userPswdContext, pswd);

		doComplexityValidation(userPswdContext, pswd);

			

		doHistoryValidation(userPswdContext, pswd);

	}

	

	public void validateForReset( UserPswdChangeContext userPswdContext, String pswd ) throws PswdValidationException {



		doLimitsValidation(userPswdContext, pswd);

		doComplexityValidation(userPswdContext, pswd);

		

	}



	private void doLimitsValidation(UserPswdChangeContext userPswdContext, String password) throws PswdLimitException {

	  PswdChangeConstraints constraints = SystemContextServiceFactory.getFactory().getService().getPswdConstraints();

	  PswdValidateLimitInterface validator = PswdValidatorFactory.getLimitValidator();

	  

	  validator.validate(constraints, userPswdContext, password);

	}

	

	private void doComplexityValidation(UserPswdChangeContext userPswdContext, String pswd) throws PswdComplexityException {

		PswdValidateComplexityInterface validator = PswdValidatorFactory.getComplexityValidator();

		validator.validate(userPswdContext, pswd);		

	

	}



	private void doHistoryValidation(UserPswdChangeContext userPswdContext, String pswd) throws PswdHistoryException {

		PswdValidateHistoryInterface validator = PswdValidatorFactory.getHistoryValidator();		

		validator.validate(userPswdContext, pswd);

	}

		

}



