package gov.va.fnod.security;



import gov.va.fnod.security.authentication.PswdHashInterface;

import gov.va.fnod.security.authorization.UserContext;

import gov.va.fnod.security.service.PswdHasherFactory;



public class PswdHelper {

	

	public static boolean pswdMatch( UserContext context, String newPswd, String hashedPswd ) {

		PswdHashInterface hasher = PswdHasherFactory.getHasher();		

		return hasher.tokensEqual(formatStoredPassword(context, newPswd), hashedPswd);	
		//TODO -- Steve remove this some time return true;
		//return true;

	}

	

	/**

	 * 

	 * By default, this method returns the password provided, but can be

	 * overridden to ally additional data from the UserContext to make password

	 * more specific to the user.

	 * 

	 * @param user

	 * @param pswd

	 * @return

	 */



	private static String formatStoredPassword(UserContext user, String pswd) {

		return String.format("%09d:%s", user.getUserId(), pswd);

	}



	public static String hashPassword(UserContext context, String pswd) {

		PswdHashInterface hasher = PswdHasherFactory.getHasher();

		return hasher.hashValue(formatStoredPassword(context,pswd));

	}

}

