package gov.va.fnod.security;

//gov.va.fnod.security.GenericPswdHash;

import gov.va.fnod.security.authentication.PswdHashInterface;
import gov.va.fnod.security.authorization.UserContext;
import gov.va.fnod.security.service.PswdHasherFactory;

import java.io.Console;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;

public class GenericPswdHash implements PswdHashInterface {

	
	public String hashValue(String password) {
		long seed = (long) (Math.random() * Long.MAX_VALUE);
		return hashValue(password, seed);
	}

	
	public String hashValue(String password, long seed) {

		byte[] pswdBytes = password.getBytes();
		byte[] seedBytes = longToBytes(seed);
		try {
			MessageDigest digest = MessageDigest.getInstance("SHA-256");
			digest.update(pswdBytes);
			digest.update(seedBytes);
			byte[] hashPswd = concatBytes(digest.digest(), seedBytes);
			return bytesToHex(hashPswd);
		} catch (NoSuchAlgorithmException e) {
			throw new IllegalStateException("Password Hasher error", e);
		}
	}

	
	public long extractSeed(String hashedValue) {
		byte[] hashBytes = hexToBytes(hashedValue);
		return (ByteBuffer.wrap(hashBytes, hashBytes.length - 8, 8)).getLong();

	}

	private byte[] concatBytes(byte[] digest, byte[] seedBytes) {
		byte[] bytes = new byte[digest.length + seedBytes.length];
		ByteBuffer buf = ByteBuffer.wrap(bytes);
		buf.put(digest).put(seedBytes);
		return bytes;
	}

	protected byte[] hexToBytes(String value) {
		int k = 0;
		byte[] results = new byte[value.length() / 2];
		for (int i = 0; i < value.length();) {
			results[k] = (byte) (Character.digit(value.charAt(i++), 16) << 4);
			results[k] += (byte) (Character.digit(value.charAt(i++), 16));
			k++;
		}
		return results;
	}

	protected String bytesToHex(byte[] value) {
		StringBuilder sb = new StringBuilder(value.length * 2);
		Formatter formatter = new Formatter(sb);
		for (byte b : value) {
			formatter.format("%02x", b);
		}
		formatter.close();
		return sb.toString();
	}

	protected byte[] longToBytes(long value) {
		byte b[] = new byte[8];
		ByteBuffer buf = ByteBuffer.wrap(b);
		buf.putLong(value);
		return b;
	}

	
	public boolean tokensEqual(String password, String hashedPassword) {
		long seed = extractSeed(hashedPassword);
		return hashedPassword.equals(hashValue(password, seed));
	}

	public static void main(String... args) {

		Console console = System.console();

		final long userId = Long.parseLong(console.readLine("User Id: "));
		final String username = console.readLine("Username: ");
		final String pswd = console.readLine("Password: ");

		UserContext uc = new UserContext() {

			
			public String getUserName() {
				return username.trim().toUpperCase();
			}

			
			public long getUserId() {
				return userId;
			}
		};

		PswdHasherFactory.registerHasher(new GenericPswdHash());	
		
		String hashedValue = PswdHelper.hashPassword(uc, pswd);
		if ( PswdHelper.pswdMatch(uc, pswd, hashedValue) ) {		
			console.printf("%s %s %s", userId, username, hashedValue);
		} else {
			
		}

	}
}
