/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.fnod.flagloader.pl.forms;

import gov.va.fnod.flagloader.be.ConfigEntity;
import gov.va.fnod.flagloader.bl.PasswordChangeController;

import javax.swing.JFrame;

public class MainForm extends javax.swing.JFrame {

	private static final long serialVersionUID = 7316523463867579645L;

	private ConfigEntity config = null;

	/**
	 *  
	 */
	public MainForm(ConfigEntity config) {
		this();		
		System.out.println("Main form: Config endpoint = " + config.getEndPoint());
		this.config = config;				
	}
	
	/**
     * Creates new form MainForm
     */
    public MainForm() {
    	
        initComponents();
        // Set default location to screen center
        setLocationRelativeTo(null);
        
        // Maximize display
        setExtendedState(getExtendedState()|JFrame.MAXIMIZED_BOTH);
    }
  
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {

    	this.setTitle("FNOD Flag Application Loader");
    	
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu2 = new javax.swing.JMenu();
        jMenu1 = new javax.swing.JMenu();
        miChangePassword = new javax.swing.JMenuItem();
        miLoadFlagApps = new javax.swing.JMenuItem();

        jMenuItem1.setText("jMenuItem1");

        jMenuItem2.setText("jMenuItem2");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jMenuBar1.add(jMenu2);

        jMenu1.setMnemonic('o');
        jMenu1.setText("Options");

        miChangePassword.setMnemonic('c');
        miChangePassword.setText("Change Password");
        miChangePassword.setToolTipText("Select to change your password.");
        miChangePassword.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miChangePasswordActionPerformed(evt);
            }
        });
        jMenu1.add(miChangePassword);

        miLoadFlagApps.setMnemonic('l');
        miLoadFlagApps.setText("Load Scanned Flag Apps");
        miLoadFlagApps.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miLoadFlagAppsActionPerformed(evt);
            }
        });
        jMenu1.add(miLoadFlagApps);

        jMenuBar1.add(jMenu1);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 279, Short.MAX_VALUE)
        );

        pack();
    }

    private void miLoadFlagAppsActionPerformed(java.awt.event.ActionEvent evt) {
       LoadFlagAppsDialog loader = new LoadFlagAppsDialog(this,config);
       loader.setVisible(true);       
    }

    private void miChangePasswordActionPerformed(java.awt.event.ActionEvent evt) {
    	PasswordChangeController controller = new PasswordChangeController(config.getEndPoint());
        ChangePasswordDialog changePasswordDialog = new ChangePasswordDialog(this, controller );
        changePasswordDialog.setVisible(true);        
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            
            public void run() {
                new MainForm().setVisible(true);
            }
        });
    }
    
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem miChangePassword;
    private javax.swing.JMenuItem miLoadFlagApps;
    
}
