/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.fnod.flagloader.pl.forms;

import gov.va.fnod.flagloader.be.ConfigEntity;
import gov.va.fnod.flagloader.bl.LoginController;
import gov.va.fnod.flagloader.bl.TaskStatusCallback;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class LoadFlagAppsDialog extends javax.swing.JDialog {
	
	private static final long serialVersionUID = 5867996507473145363L;
	
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MMM-dd hh:mm:ss a");
	
	private javax.swing.JButton exitButton;
	private javax.swing.JLabel statusLabel;
	private javax.swing.JScrollPane statusScrollPanel;
	private javax.swing.JTextArea statusText;

	private int returnStatus = RET_CANCEL;
	
	/**
	 * A return status code - returned if Cancel button has been pressed
	 */
	public static final int RET_CANCEL = 0;
	/**
	 * A return status code - returned if OK button has been pressed
	 */
	public static final int RET_OK = 1;

	private JFrame parentFrame;
	private ConfigEntity config;

	public LoadFlagAppsDialog(JFrame parent, ConfigEntity config) {
		this(parent);
		this.config = config;
	}

	/**
	 * Creates new form LoadFlagAppsDialog
	 */
	public LoadFlagAppsDialog(JFrame parent) {
		super(parent, true);
		parentFrame = parent;
		initComponents();

		centerOnParent();
	}

	private void centerOnParent() {

		int px = parentFrame.getX();
		int py = parentFrame.getY();
		int ph = parentFrame.getHeight();
		int pw = parentFrame.getWidth();

		int dh = this.getHeight();
		int dw = this.getWidth();

		int y = py + ((ph - dh) / 3);
		int x = px + ((pw - dw) / 2);

		setLocation(x, y);
	}

	/**
	 * @return the return status of this dialog - one of RET_OK or RET_CANCEL
	 */
	public int getReturnStatus() {
		return returnStatus;
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	private void initComponents() {

		exitButton = new javax.swing.JButton();
		statusScrollPanel = new javax.swing.JScrollPane();
		statusText = new javax.swing.JTextArea();
		statusLabel = new javax.swing.JLabel();

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				closeDialog(evt);
			}

			public void windowOpened(java.awt.event.WindowEvent evt) {
				formWindowOpened(evt);
			}
		});

		exitButton.setText("Exit");
		exitButton.setEnabled(false);
		exitButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				cancelButtonActionPerformed(evt);
			}
		});

		//statusText.setEditable(false);
		statusText.setColumns(20);
		statusText.setLineWrap(true);
		statusText.setRows(5);
		statusText.getDocument().addDocumentListener(
				new LimitLinesDocumentListener(2000, true /* from start */));
		statusScrollPanel.setViewportView(statusText);

		statusLabel.setText("Status");

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(
				getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(layout
				.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(
						layout.createSequentialGroup()
								.addContainerGap()
								.addGroup(
										layout.createParallelGroup(
												javax.swing.GroupLayout.Alignment.LEADING)
												.addGroup(
														javax.swing.GroupLayout.Alignment.TRAILING,
														layout.createSequentialGroup()
																.addGap(0,
																		0,
																		Short.MAX_VALUE)
																.addComponent(
																		exitButton))
												.addComponent(
														statusScrollPanel,
														javax.swing.GroupLayout.DEFAULT_SIZE,
														584, Short.MAX_VALUE)
												.addGroup(
														layout.createSequentialGroup()
																.addComponent(
																		statusLabel)
																.addGap(0,
																		0,
																		Short.MAX_VALUE)))
								.addContainerGap()));
		layout.setVerticalGroup(layout.createParallelGroup(
				javax.swing.GroupLayout.Alignment.LEADING).addGroup(
				javax.swing.GroupLayout.Alignment.TRAILING,
				layout.createSequentialGroup()
						.addContainerGap()
						.addComponent(statusLabel)
						.addGap(7, 7, 7)
						.addComponent(statusScrollPanel,
								javax.swing.GroupLayout.DEFAULT_SIZE, 438,
								Short.MAX_VALUE).addGap(18, 18, 18)
						.addComponent(exitButton).addContainerGap()));

		pack();
	}

	private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_cancelButtonActionPerformed
		doClose(RET_CANCEL);
	}

	/**
	 * Closes the dialog
	 */
	private void closeDialog(java.awt.event.WindowEvent evt) {
		if ( exitButton.isEnabled() ) {
			doClose(RET_CANCEL);
		}
	}

	private void formWindowOpened(java.awt.event.WindowEvent evt) {
		LoginController controller = new LoginController(config.getEndPoint());
		LoginDialog login = new LoginDialog(parentFrame, controller);
		login.setVisible(true);
		if (LoginDialog.RET_FAILED == login.getReturnStatus()) {
			doClose(RET_CANCEL);
		} else if ( LoginDialog.RET_CANCEL == login.getReturnStatus() ) {
			doClose(RET_CANCEL);
		} else {		
			new FlagAppLoadWorker(config, login.getUserCredentials(), getCallback()).execute();
		}
		
	}
	
	private TaskStatusCallback getCallback() {
		return new TaskStatusCallback() {

			public void log(Level level, final String message) {

				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						statusText.append(sdf.format(new Date()) + ": "
								+ message + "\n");
					}
				});
			}

			
			public void log(Level level, Throwable cause) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos);
				cause.printStackTrace(ps);
				log(level, bos.toString());
			}

			public void log(Level level, String message, Throwable cause) {
				log(level, message);
			}

			public void onCompleted(boolean isSuccess) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						statusText.append("\n\nProcessing has completed, click exit button to close.");
						exitButton.setEnabled(true);
					}
				});
			}

		};
	}

	private void doClose(int retStatus) {
		returnStatus = retStatus;
		setVisible(false);
		dispose();
	}

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		try {
			for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager
					.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					javax.swing.UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (ClassNotFoundException ex) {
			java.util.logging.Logger.getLogger(
					LoadFlagAppsDialog.class.getName()).log(
					java.util.logging.Level.SEVERE, null, ex);
		} catch (InstantiationException ex) {
			java.util.logging.Logger.getLogger(
					LoadFlagAppsDialog.class.getName()).log(
					java.util.logging.Level.SEVERE, null, ex);
		} catch (IllegalAccessException ex) {
			java.util.logging.Logger.getLogger(
					LoadFlagAppsDialog.class.getName()).log(
					java.util.logging.Level.SEVERE, null, ex);
		} catch (javax.swing.UnsupportedLookAndFeelException ex) {
			java.util.logging.Logger.getLogger(
					LoadFlagAppsDialog.class.getName()).log(
					java.util.logging.Level.SEVERE, null, ex);
		}

		/* Create and display the dialog */
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				LoadFlagAppsDialog dialog = new LoadFlagAppsDialog(
						new javax.swing.JFrame());
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					@Override
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

}
