/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.fnod.flagloader.pl.forms;

import gov.va.fnod.flagloader.bl.PasswordChangeController;
import gov.va.fnod.flagloader.exception.PasswordException;
import gov.va.fnod.flagloader.exception.PasswordRetriesExceededException;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;


public class ChangePasswordDialog extends javax.swing.JDialog {

    private static final long serialVersionUID = -2076306655942888111L;
	
    /**
     * A return status code - returned if Cancel button has been pressed
     */
    public static final int RET_CANCEL = 0;
    /**
     * A return status code - returned if OK button has been pressed
     */
    public static final int RET_OK = 1;

    private JFrame parentFrame;
    private PasswordChangeController controller;
    
	public ChangePasswordDialog(JFrame parent, PasswordChangeController controller) {
		this(parent);
		this.controller = controller;
	}
    
    /**
     * Creates new form ChangePasswordDialog
     */
    @SuppressWarnings("serial")
	public ChangePasswordDialog(JFrame parent) {
        super(parent);
        parentFrame = parent;
        initComponents();
        positionOnParent();

        // Close the dialog when Esc is pressed
        String cancelName = "cancel";
        InputMap inputMap = getRootPane().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), cancelName);
        ActionMap actionMap = getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction() {
            
            public void actionPerformed(ActionEvent e) {
                doClose(RET_CANCEL);
            }
        });
    }
    
    private void positionOnParent() {
        
        int px = parentFrame.getX();
        int py = parentFrame.getY();
        int ph = parentFrame.getHeight();
        int pw = parentFrame.getWidth();
        
        int dh = this.getHeight();
        int dw = this.getWidth();
        
        int y = py + ((ph-dh)/3);
        int x = px + ((pw-dw)/2);
        
        setLocation(x, y);
    }
    
    /**
     * @return the return status of this dialog - one of RET_OK or RET_CANCEL
     */
    public int getReturnStatus() {
        return returnStatus;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        usernameLabel = new javax.swing.JLabel();
        usernameText = new javax.swing.JTextField();
        currentPasswordLabel = new javax.swing.JLabel();
        passwordText = new javax.swing.JPasswordField();
        newPasswordLabel = new javax.swing.JLabel();
        newPasswordText = new javax.swing.JPasswordField();
        
        verifyPasswordText = new javax.swing.JPasswordField();
        verifyNewPasswordLabel = new javax.swing.JLabel();

        setTitle("Change Password");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        usernameLabel.setLabelFor(usernameText);
        usernameLabel.setText("Username");

        currentPasswordLabel.setLabelFor(passwordText);
        currentPasswordLabel.setText("Current Password");

        newPasswordLabel.setLabelFor(newPasswordText);
        newPasswordLabel.setText("New Password");

        verifyNewPasswordLabel.setLabelFor(verifyPasswordText);
        verifyNewPasswordLabel.setText("Verify New Password");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap(475, Short.MAX_VALUE)
                        .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cancelButton))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(usernameLabel)
                            .addComponent(currentPasswordLabel)
                            .addComponent(newPasswordLabel)
                            .addComponent(verifyNewPasswordLabel))
                        .addGap(18, 18, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(usernameText, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 472, Short.MAX_VALUE)
                            .addComponent(passwordText, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(newPasswordText, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(verifyPasswordText, javax.swing.GroupLayout.Alignment.TRAILING))))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(35, 35, 35)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(usernameLabel)
                    .addComponent(usernameText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(passwordText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(currentPasswordLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(newPasswordText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(newPasswordLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(verifyNewPasswordLabel)
                    .addComponent(verifyPasswordText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        getRootPane().setDefaultButton(okButton);

        pack();
    }

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {
    	disableButtons();
    	try {
    		List<String> errMsgs = controller.validate(getUsername(), getPassword(), getNewPassword(), getVerifyPassword());
    		if ( ! errMsgs.isEmpty() ) {
    			StringBuilder sb = new StringBuilder("Unable to change password:\n");
    			for(String msg: errMsgs) {
    				sb.append("   * ").append(msg).append('\n');
    			}
    			sb.append("Please correct errors and try again.");
    			JOptionPane.showMessageDialog(this,sb.toString(),"Validation Error",JOptionPane.ERROR_MESSAGE);
    		} else {
    			try {
    				controller.submitPasswordChange(getUsername(), getPassword(), getNewPassword());
    				JOptionPane.showMessageDialog(this, "Password changed", "Success", JOptionPane.INFORMATION_MESSAGE);
    				doClose(RET_OK);
    			} catch ( PasswordException ex ) {
    				JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);    			
    			} catch (PasswordRetriesExceededException ex) {
    				JOptionPane.showMessageDialog(this, ex.getMessage()+"\n try again later", "Error", JOptionPane.ERROR_MESSAGE);
    				doClose(RET_CANCEL);
    			}    		
    		}
    	} finally {
    		enableButtons();
    	}
    }
    
    private void disableButtons() {
    	okButton.setEnabled(false);
    }
    
    private void enableButtons() {
    	okButton.setEnabled(true);
    }
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose(RET_CANCEL);
    }

    /**
     * Closes the dialog
     */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }
    
    private String getUsername() {
    	return usernameText.getText();
    }
    
    private String getPassword() {
    	return new String(passwordText.getPassword());
    }
    
    private String getNewPassword() {
    	return new String(newPasswordText.getPassword());
    }
    
    private String getVerifyPassword() {
    	return new String(verifyPasswordText.getPassword());
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(ChangePasswordDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(ChangePasswordDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(ChangePasswordDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(ChangePasswordDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            
            public void run() {
                ChangePasswordDialog dialog = new ChangePasswordDialog(new javax.swing.JFrame());
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel currentPasswordLabel;
    private javax.swing.JLabel newPasswordLabel;
    private javax.swing.JPasswordField newPasswordText;
    private javax.swing.JButton okButton;
    private javax.swing.JPasswordField passwordText;
    private javax.swing.JLabel usernameLabel;
    private javax.swing.JTextField usernameText;
    private javax.swing.JLabel verifyNewPasswordLabel;
    private javax.swing.JPasswordField verifyPasswordText;
    // End of variables declaration//GEN-END:variables
    private int returnStatus = RET_CANCEL;
}
