package gov.va.fnod.flagloader.pl;



import gov.va.fnod.flagloader.be.ConfigEntity;



import java.io.File;

import java.io.IOException;



import javax.xml.parsers.ParserConfigurationException;

import javax.xml.parsers.SAXParser;

import javax.xml.parsers.SAXParserFactory;



import org.xml.sax.Attributes;

import org.xml.sax.SAXException;

import org.xml.sax.helpers.DefaultHandler;



class ConfigXmlParser extends DefaultHandler {



    private StringBuilder curNode = new StringBuilder();

    private StringBuilder curText = new StringBuilder();



    private ConfigEntity config;



    /**

     * The no-arg constructor is made private to force use of the class via

     * its static interface.

     */

    private ConfigXmlParser() {

        super();

    }



    /**

     * Parses xml file, returning ConfigEntity.

     *

     * @param xmlFilename path to xml configuration file

     * @return ConfigEntity populated with data from xml configuration file

     */

    public static ConfigEntity load(String xmlFilename) {



        SAXParserFactory factory = SAXParserFactory.newInstance();

        factory.setValidating(true);



        SAXParser parser;



        try {

            parser = factory.newSAXParser();

        } catch (ParserConfigurationException e) {

            throw new RuntimeException("Can't get parser factory", e);

        } catch (SAXException e) {

            throw new RuntimeException("Can't get parser factory", e);

        }



        ConfigXmlParser xmlHandler = new ConfigXmlParser();



        try {

            parser.parse(new File(xmlFilename), xmlHandler);

        } catch (SAXException e) {

            throw new RuntimeException("Failed parsing config file", e);

        } catch (IOException e) {

            throw new RuntimeException("Failed to open config file", e);

        }



        return xmlHandler.config;

    }



    /**

     * Intitializes configuration.

     * @throws SAXException

     */

    @Override

    public void startDocument() throws SAXException {

        curNode.setLength(0);

        curText.setLength(0);

    }



    @Override

    public void startElement(String uri, String localName, String qName,

                             Attributes attributes) throws SAXException {

        curText.setLength(0);

        pushNode(qName);



        String node = curNode.toString();



        if ("config".equals(node)) {            

        	config = new ConfigEntity();

        } else if ("config.endpoint".equals(node)){

        	config.setEndPoint(attributes.getValue("url"));        	

        } else if ("config.directories.directory".equals(node)) {



        	String type = attributes.getValue("type");

        	String path = attributes.getValue("path");

        	if ("source".equals(type) ) {

        		config.setSourceDirPath(path);

        	} else if ("working".equals(type) ) {

        		config.setWorkingDirPath(path);

        	} else if ("completed".equals(type) ) {

        		config.setCompletedDirPath(path);

        	}           

        }



    }



    @Override

    public void characters(char[] ch, int start,

                           int length) throws SAXException {

        curText.append(ch, start, length);

    }



    @Override

    public void endElement(String uri, String localName,

                           String qName) throws SAXException {

        popNode(qName);

    }



    @Override

    public void endDocument() throws SAXException {

        

        if (curNode.length() > 0) {

            throw new IllegalStateException("node not removed");

        }

    }



    private void pushNode(String qName) {

        if (curNode.length() > 0) {

            curNode.append('.');

        }

        curNode.append(qName);

    }



    private void popNode(String qName) {

        if (curNode.toString().endsWith('.' + qName)) {

            curNode.setLength(curNode.lastIndexOf("."));

        } else if (curNode.toString().endsWith(qName)) {

            curNode.setLength(0);

        } else {

            throw new IllegalStateException("can remove expected node");

        }

    }



 

}

