package gov.va.fnod.flagloader.dl;



import gov.va.fnod.flagloader.be.VipDataEntity;

import gov.va.fnod.flagloader.exceptions.VipInvalidFormatException;



import java.io.BufferedReader;

import java.io.IOException;

import java.io.Reader;

import java.text.SimpleDateFormat;



/**

 * This class is responsible for reading the content of a Feith VIP file and output a VipDataEntity object. 

 * 

 * @author Jim Lindelof

 */

public class VipReader implements VipReadable {

	

	

	public VipDataEntity read(Reader vipInput) {

		

		BufferedReader bufReader;

		

		if ( ! (vipInput instanceof BufferedReader) ) {

			bufReader = new BufferedReader(vipInput);

		} else {

			bufReader = (BufferedReader)vipInput;

		}

		

		VipDataEntity retval = new VipDataEntity();

		

		String line;

		try {

			while ( (line = bufReader.readLine()) != null ) {

				

				if ( line.startsWith("Feith VIP") ) {

				    retval.setVersion(extractValue("Feith VIP",line)); 	

				} else if ( line.startsWith("Date:") ) {

					/* 

					 * The date and time are are two separate lines, but we need to store them

					 * as a single value, so as soon as date is found, the read of time is forced.

					 * This could cause problems with partial file (which is invalid anyway).

					 */

					

					StringBuilder dateTime = new StringBuilder();

					

					dateTime.append(extractValue("Date:", line)).append(" ");

					

					line = bufReader.readLine();

					if ( line.startsWith("Time:") ) {

						dateTime.append(extractValue("Time:", line));						

					} else {

						throw new VipInvalidFormatException("Date time error");

					}

					

					// Now we have both parts, parse time stamp

					try {						

						SimpleDateFormat dateFmt = new SimpleDateFormat("M/d/yyyy h:m:s a"); 

						retval.setTimestamp( dateFmt.parse(dateTime.toString()) );

					} catch (Exception ex) {

						throw new VipInvalidFormatException("Error parsing date time",ex);

					}

				} else if ( line.startsWith("Batch ID:") ) {

					String value = extractValue("Batch ID:",line);

					retval.setBatchId(value==null ? null : Long.valueOf(value));

				} else if ( line.startsWith("MODE:") ) {

					retval.setMode(extractValue("MODE:",line));

				} else if ( line.startsWith("PBC01:") ) {

					retval.setPbc(extractValue("PBC01:",line));

				} else if ( line.startsWith("File:") ) {

					retval.getFilePaths().add(extractValue("File:",line));

				}

				

			}

		} catch (IOException ex) {

			// TODO Auto-generated catch block

			ex.printStackTrace();

		}

		

		return retval;

	}



	private String extractValue(String label, String line) {

		return line.substring(label.length()).trim();

	}

}

