package gov.va.fnod.flagloader.dl;



import gov.va.fnod.flagloader.be.Constants;
import gov.va.fnod.flagloader.be.FnodMetadata;
import gov.va.fnod.flagloader.be.UserCredentials;
import gov.va.fnod.soa_common.model.flagapp.Authentication;
import gov.va.fnod.soa_common.model.flagapp.FlagApp;
import gov.va.fnod.soa_common.model.flagapp.FlagAppPayload;
import gov.va.fnod.soa_common.model.flagapp.PasswordChange;
import gov.va.fnod.soa_common.service.FlagClientServiceBean;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;



public class FlagAppService {

	

	private String endpoint;

	

	public FlagAppService(String endpoint) {

		this.endpoint = endpoint;

	}



	public void changePassword(String username, String oldPassword, String newPassword) {		

		FlagClientServiceBean serviceBean = new FlagClientServiceBean();

		

		PasswordChange pc = new PasswordChange();

		pc.setUsername(username);

		pc.setPassword(oldPassword);

		pc.setNewPassword(newPassword);

		

		serviceBean.changeFlagAppPswd(endpoint, pc);

	}

	

	public void login(String username, String password) {

		FlagClientServiceBean serviceBean = new FlagClientServiceBean();

		Authentication auth = new Authentication();

		auth.setUsername(username);

		auth.setPassword(password);

		

		serviceBean.authFlagAppUser(endpoint, auth);		

	}

	

	public Long submitFlagApp(UserCredentials userCreds, FnodMetadata data, byte[] pdfData, String pdfFilename) { 
		String method = "FlagAppService.submitFlagApp";
		
		
		FlagApp flagApp = new FlagApp();

		System.out.println(method + ": Populating flagApp Object");

		flagApp.setReportedDate(this.convertDateToXML(data.getProcessDt()));

		flagApp.setCaseTypeCd(FlagApp.CASE_TYPE_CD);

		flagApp.setSourceSystemCd(FlagApp.SOURCE_SYSTEM_CD);

		

		flagApp.setScanProcessDt(this.convertDateToXML(data.getProcessDt()));

		

		flagApp.setRegionCd(data.getRegionCode());

		flagApp.setScanBatchDt(this.convertDateToXML(data.getBatchDate()));

		flagApp.setScanBatchId(data.getBatchId());



		flagApp.setScanDocDt(this.convertDateToXML(data.getDocumentDate()));

		flagApp.setScanDocId(data.getDocumentId());

	

		flagApp.setFileName(pdfFilename);

		flagApp.setPdfFile(pdfData);

		
		System.out.println(method + ": Done Populating object");
		
		System.out.println(method + ": Authenticate using: id: " + userCreds.getUsername());
		

		Authentication auth = new Authentication();

		auth.setUsername(userCreds.getUsername());

		auth.setPassword(userCreds.getPassword());		
		System.out.println(method + "Authenticate population done..");

		System.out.println(method + ": Adding new FlagAppPayload");
		FlagAppPayload flagAppPayload = new FlagAppPayload();

		flagAppPayload.setAuthentication(auth);

		flagAppPayload.setVersion(Constants.FLAG_APP_PAYLOAD_VERSION);

		flagAppPayload.setFlagApp(flagApp);
		System.out.println(method + ": Done adding FlgaAppPayload");
		
		System.out.println(method + ": Contacting Client Service bean");
		FlagClientServiceBean flagClientServiceBean = new FlagClientServiceBean(); 		
		
		
		return flagClientServiceBean.submit(endpoint, flagAppPayload);

	}


	private XMLGregorianCalendar convertDateToXML(Date d) {
		GregorianCalendar c = new GregorianCalendar();
		c.setTime(d);
		try {
			return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
		} catch (DatatypeConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

}

