package gov.va.fnod.flagloader.bl;



/** 

 * This interface support a call back interface used to post process

 * status to the front end application.  In addition to providing

 * a message interface, the interface also supports a signaling

 * process termination and if it was successful or failed.

 */

public interface TaskStatusCallback {

	

	public enum Level {

		FATAL, 

		ERROR, 

		WARNING, 

		INFO, 

		DEBUG,

		TRACE;

	}

	

	public void log(Level level, String message);

	public void log(Level level, Throwable cause);

	public void log(Level level, String message, Throwable cause);

	

	public void onCompleted(boolean isSuccess);



}

