package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.be.ReportEntity;

import gov.va.fnod.flagloader.bl.TaskStatusCallback.Level;



import java.io.File;

import java.io.FileFilter;

import java.io.FileWriter;

import java.io.IOException;



public class TaskFinalize extends TaskBase {



	@Override

	protected void doRun() {

		

		log(Level.INFO,"Starting finalization.");

		

		generateReport();

		archiveFiles();

		moveFilesToCompleted();

	}



	/**

	 * The report takes the values stored in the transmit and process logs and

	 * summarizes the value by regional office and date, count number of

	 * application and summing number if pages. Values will be merged into one

	 * row per regional office, date pair. A total will not be included a the

	 * bottom.

	 * 

	 * Finalize summary will be written to disk as CSV file.

	 * 

	 * @return

	 */

	private void generateReport() {

		

		log(Level.INFO, "Producing summary report.");

		

		ReportGenerator rg = new ReportGenerator();

		

		rg.fill(ReportEntity.Source.PRODUCTION, new File(getWorkingDir(),

				FilenameHelper.getProcessReportFilename(getState())));

		rg.fill(ReportEntity.Source.TRANSMITION, new File(getWorkingDir(),

				FilenameHelper.getTransmissionReportFilename(getState())));

		

		String summaryFilename = FilenameHelper.getSummaryReportFilename(getState());

		File summaryFile = new File(getWorkingDir(), summaryFilename);

		try {

			FileWriter fw = new FileWriter(summaryFile);

			try {

				rg.generateReport(fw);

			} finally {

				fw.close();

			}

		} catch (IOException ex) {

			// TODO Auto-generated catch block

			ex.printStackTrace();

		}

	}



	/**

	 * Move the process log file and the transmission log file into the process archive then

	 * add (not move) the summary report to the process archive.

	 */

	private void archiveFiles() {

		

		log(Level.INFO,"Creating final archive.");

		

		File tmpDir = new File(getWorkingDir(), FilenameHelper.getTempCompletedDirName(getState()));

		tmpDir.mkdir();

		

		for( File file: getFinalFiles() ) {

			File dest = new File(tmpDir,file.getName());

			file.renameTo(dest);

		}

		

		File zipFile = new File(getWorkingDir(),FilenameHelper.getCompeletedFileName(getState()));

		try {

			DirZipper.zipDir(tmpDir, zipFile);			

		} catch (IOException ex) {

			throw new RuntimeException("Failed to assemble final archive.",ex);

		}

		DirectoryUtils.removeFiles(tmpDir);

	}

	

	private File[] getFinalFiles() {

		final String filePrefix = FilenameHelper.getProcessTimeStamp(getState());

		

		return getWorkingDir().listFiles(new FileFilter() {			

			

			public boolean accept(File file) {				

				return file.getName().startsWith(filePrefix);

			}			

		});

		

	}



	private void moveFilesToCompleted() {

		File src = new File(getWorkingDir(),FilenameHelper.getCompeletedFileName(getState()));

		File dest = new File(getCompletedDir(), src.getName());

		src.renameTo(dest);

		log(Level.INFO,"Final archive moved to completed");

	}

}

