package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.be.ConfigEntity;

import gov.va.fnod.flagloader.be.ProcessState;

import gov.va.fnod.flagloader.be.Tasks;



import java.util.EnumMap;

import java.util.Map;



public class TaskFactory {



	static final private Map<Tasks, TaskBase> taskMap;

	static final private Map<Tasks, Tasks> nextTaskMap;



	static {

		taskMap = new EnumMap<Tasks, TaskBase>(Tasks.class);

		nextTaskMap = new EnumMap<Tasks, Tasks>(Tasks.class);



		taskMap.put(Tasks.BACKUP_SOURCE, new TaskBackupSource());

		nextTaskMap.put(Tasks.BACKUP_SOURCE, Tasks.MOVE_SOURCE_TO_WORK);



		taskMap.put(Tasks.MOVE_SOURCE_TO_WORK, new TaskMoveSourceFiles());

		nextTaskMap.put(Tasks.MOVE_SOURCE_TO_WORK, Tasks.CREATE_MESSAGES);

		

		taskMap.put(Tasks.CREATE_MESSAGES, new TaskCreateMessage());

		nextTaskMap.put(Tasks.CREATE_MESSAGES, Tasks.TRANSMIT_MESSAGES);

		

		taskMap.put(Tasks.TRANSMIT_MESSAGES, new TaskTransmitMessages());

		nextTaskMap.put(Tasks.TRANSMIT_MESSAGES, Tasks.FINALIZE);

		

		taskMap.put(Tasks.FINALIZE, new TaskFinalize() );

		nextTaskMap.put(Tasks.FINALIZE, null);

	}



	public static TaskBase getInstance(ProcessState ps, ConfigEntity config, TaskStatusCallback statusAppender ) {

		TaskBase pr = taskMap.get(ps.getTask());

		if (pr != null) {

			pr.init(ps, config, statusAppender);

		}

		return pr;

	}



	public static TaskBase getNextInstance(ProcessState ps,	ConfigEntity config, TaskStatusCallback statusAppender) {

		Tasks task = nextTaskMap.get(ps.getTask());

		if (task != null) {

			// advancing state

			ps.setTask(task);

			return getInstance(ps,config,statusAppender);

		}

		return null;

	}



}

