package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.be.ConfigEntity;
import gov.va.fnod.flagloader.be.ProcessState;



import gov.va.fnod.flagloader.bl.TaskStatusCallback.Level;

import java.io.File;



public abstract class TaskBase implements Runnable {



	private ProcessState state;

	private ConfigEntity config;



	private File sourceDir;

	private File workingDir;

	private File completedDir;

	private TaskStatusCallback statusAppender;

 

	public void init(ProcessState state, ConfigEntity config, TaskStatusCallback statusAppender) {
		log(Level.INFO,"TaskBase.init");
		System.out.println("Endpoint: " + config.getEndPoint());
		System.out.println("Source dir: " + config.getSourceDirPath());
		System.out.println("Working Dir: " + config.getWorkingDirPath());
		System.out.println("Completed Dir: " + config.getCompletedDirPath());
				
		log(Level.INFO,"Web Service: " + config.getEndPoint());
		log(Level.INFO,"Source dir: " + config.getSourceDirPath());
		log(Level.INFO,"Working Dir: " + config.getWorkingDirPath());
		log(Level.INFO,"Completed Dir: " + config.getCompletedDirPath());
		
		
		this.state = state;

		this.config = config;

		this.statusAppender = statusAppender;

	}



	protected ProcessState getState() {

		return state;

	}



	protected ConfigEntity getConfig() {

		return config;

	}



	
	public void run() {

		saveState();

		doRun();

	}



	protected abstract void doRun();

 

	protected void saveState() {		

		StateFileManager sfm = new StateFileManager(config.getWorkingDirPath());

		sfm.writeStateFile(state);

	}



	protected File getSourcDir() {

		if (sourceDir == null) {

			sourceDir = new File(config.getSourceDirPath());

		}

		return sourceDir;

	}



	protected File getWorkingDir() {

		if (workingDir == null) {

			workingDir = new File(config.getWorkingDirPath());

		}

		return workingDir;

	}

	

	protected File getCompletedDir() {

		if (completedDir == null) {

			completedDir = new File(config.getCompletedDirPath());

		}

		return completedDir;

	}

	

	protected void log(TaskStatusCallback.Level level, String message) {

		

		if (statusAppender != null) {

			statusAppender.log(level, message);

		}

	}

	

	protected void log(TaskStatusCallback.Level level, Throwable cause) {

		if (statusAppender != null) {

			statusAppender.log(level, cause);

		}

	}

	

	protected void log(TaskStatusCallback.Level level, String message, Throwable cause) {

		if (statusAppender != null) {

			statusAppender.log(level, message, cause);

		}

	}

	

	

}

