package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.bl.TaskStatusCallback.Level;




import java.io.File;
import java.io.IOException;



/**

 * This class is responsible for backing up the source directory before processing begins. 

 *

 */

public class TaskBackupSource extends TaskBase {

	

	@Override

	protected void doRun() {

		log(Level.INFO,"TaskBackupSource.dorun..");
		log(Level.INFO,"Endpoint: " + getConfig().getEndPoint());
		System.out.println("Endpoint: " + getConfig().getEndPoint());

		File workingDir = new File(getConfig().getWorkingDirPath());

		log(Level.INFO,"Archiving scanned files.");

		File archFile = new File(workingDir,FilenameHelper.getSourceArchiveFilename(getState()));

		try {

			DirZipper.zipDir(getSourcDir(), archFile);

		} catch (IOException ex) {

			throw new RuntimeException("Failed to archive source data",ex);

		}

		

	}	

	

}

