package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.be.FnodMetadata;

import gov.va.fnod.flagloader.be.ReportEntity;

import gov.va.fnod.flagloader.be.ReportKey;



import java.io.BufferedReader;

import java.io.File;

import java.io.FileNotFoundException;

import java.io.FileReader;

import java.io.IOException;

import java.io.Writer;

import java.text.SimpleDateFormat;

import java.util.EnumMap;

import java.util.Map;

import java.util.TreeMap;



public class ReportGenerator {



	private Map<ReportKey, Map<ReportEntity.Source, ReportEntity>> summary;



	public ReportGenerator() {

		super();

		summary = new TreeMap<ReportKey, Map<ReportEntity.Source, ReportEntity>>();

	}



	public void fill(ReportEntity.Source src, File file) {

		try {

			BufferedReader reader = new BufferedReader(new FileReader(file));

			try {

				String formattedMetadata;

				while ((formattedMetadata = reader.readLine()) != null) {

					FnodMetadata data = FnodMetadataHelper

							.parseFormattedMetadata(formattedMetadata);

					ReportKey key = new ReportKey(data.getRegionCode(),

							data.getProcessDt());

					ReportEntity entity = new ReportEntity();

					entity.setSrc(src);

					entity.setNumPages(data.getNumPages());

					entity.setCount(Integer.valueOf(1));



					addValues(key, entity);

				}

			} finally {

				reader.close();

			}

		} catch (FileNotFoundException ex) {

			throw new RuntimeException("File not found: "+file.getAbsolutePath(), ex);

		} catch (IOException ex) {

			throw new RuntimeException("Failed to read: "+file.getAbsolutePath(), ex);

		}

	}



	private void addValues(ReportKey key, ReportEntity entity) {



		// Lookup region, batch date

		Map<ReportEntity.Source, ReportEntity> valueMap = summary.get(key);

		if (valueMap == null) {

			// If key not found, initialize map for key

			valueMap = new EnumMap<ReportEntity.Source, ReportEntity>(

					ReportEntity.Source.class);

			valueMap.put(entity.getSrc(), entity);

			summary.put(key, valueMap);

		} else {

			// Otherwise we found the key, so try to get the source record

			ReportEntity value = valueMap.get(entity.getSrc());

			if (value != null) {

				// Entry was found, so increment values

				value.setCount(value.getCount() + 1);

				value.setNumPages(value.getNumPages() + entity.getNumPages());

			} else {

				// otherwise, add provided data as entry

				valueMap.put(entity.getSrc(), entity);

			}

		}

	}



	/**

	 * region, date, proc_apps, proc_pages, trans_apps, trans_pages

	 */

	public void generateReport(Writer writer) {

		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a");

		StringBuilder sb = new StringBuilder();

		ReportEntity values;



		try {

			// Write the header for the summary data file.

			writer.write("RegionCd,Process Date,Process Apps,Process Pages,Transmitted Apps,Transmitted Pages");



			// And then the data

			for (Map.Entry<ReportKey, Map<ReportEntity.Source, ReportEntity>> entry : summary

					.entrySet()) {

				ReportKey key = entry.getKey();



				sb.setLength(0);

				

				sb.append("\n");

				sb.append(key.getRegionCode()).append(",");

				sb.append(sdf.format(key.getProcessDate())).append(",");



				values = entry.getValue().get(ReportEntity.Source.PRODUCTION);

				sb.append(values.getCount()).append(",");

				sb.append(values.getNumPages()).append(",");



				values = entry.getValue().get(ReportEntity.Source.TRANSMITION);

				sb.append(values.getCount()).append(",");

				sb.append(values.getNumPages());

				

				writer.write(sb.toString());



			}

		} catch (IOException ex) {

			throw new RuntimeException("Failed to save summary report.", ex);

		}



	}

}

