package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.dl.FlagAppService;

import gov.va.fnod.flagloader.exception.PasswordException;

import gov.va.fnod.flagloader.exception.PasswordRetriesExceededException;



import java.util.ArrayList;

import java.util.List;



public class PasswordChangeController {



	private String endpoint;

	private int attempts = 0;

	

	public PasswordChangeController(String endpoint) {

		this.endpoint = endpoint;

	}

	

	public List<String> validate(String username, String oldPassword, String newPassword, String verifyPassword ) {

		

		List<String> errMsg = new ArrayList<String>();

		

		if ( !requiredStringValid(username) ) {

			errMsg.add("User name cannot be blank.");

		}

		

		if ( !requiredStringValid(oldPassword) ) {

			errMsg.add("Current password name cannot be blank.");

		}

		

		if ( !requiredStringValid(newPassword) ) {

			errMsg.add("New password name cannot be blank.");

		}

		

		if ( !requiredStringValid(verifyPassword) ) {

			errMsg.add("Verify password name cannot be blank.");

		}

		

		if ( oldPassword != null && newPassword != null ) {

			if ( oldPassword.equals(newPassword) ) {

				errMsg.add("New password must be different from current password.");

			}

		}

		

		if ( newPassword != null && verifyPassword != null ) {

			if ( ! newPassword.equals(verifyPassword) ) {

				errMsg.add("New password and Verify password are different.");

			}

		}

		

		return errMsg;

		

	}

	

	public void submitPasswordChange(String username, String oldPassword, String newPassword) {



		FlagAppService service = new FlagAppService(endpoint);

		try {

			attempts++;

			service.changePassword(username, oldPassword, newPassword);

		} catch (Exception ex) {

			if ( attempts < 3 ) {

				throw new PasswordException("Password Change failed on server",ex);

			} else {

				throw new PasswordRetriesExceededException("Password Change failed on server",ex);

			}			

		}

	}

	

	

	private boolean requiredStringValid(String value) {

		return value != null && !value.isEmpty();

	}

	

}

