package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.dl.FlagAppService;

import gov.va.fnod.flagloader.exception.PasswordException;

import gov.va.fnod.flagloader.exception.PasswordRetriesExceededException;



import java.util.ArrayList;

import java.util.List;



public class LoginController {

	

	private int attempts = 0;

	private String endpoint;

	

	public LoginController(String endpoint) {

		this.endpoint = endpoint;

	}

	

	public List<String> validateLoginParams(String username, String password) {

		List<String> errMsgs = new ArrayList<String>();

		

		if ( username == null || username.isEmpty() ) {

			errMsgs.add("Username cannot be blank.");

		}

		

		if ( password == null || password.isEmpty() ) {

			errMsgs.add("Password cannot be blank.");

		}

		

		return errMsgs;

	}

	

	public void login(String username, String password) {

		FlagAppService service = new FlagAppService(endpoint);

		try {

			if( attempts < 3) {

				attempts++;

				service.login(username, password);

			}

		} catch (Exception ex) {

			if ( attempts < 3 ) {

				throw new PasswordException("Login Failed", ex);

			} else {

				throw new PasswordRetriesExceededException("Login Failed", ex);

			}			

		}

	}	

	

}

