package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.be.FnodMetadata;



import java.text.ParseException;

import java.text.SimpleDateFormat;



public class FnodMetadataHelper {

	

	// These have to match the order item are written in formatMetadata

	private static final int PROCESS_DATE  = 0;

	private static final int BATCH_ID      = 1;

	private static final int BATCH_DATE    = 2;

	private static final int REGION_CD     = 3;

	private static final int DOCUMENT_ID   = 4;

	private static final int DOCUMENT_DATE = 5;

	private static final int NUM_PAGES 	   = 6;

	private static final int CASE_LINK_ID  = 7;

	

	private static final char DELIMITER='|';

	private static final String splitRegex = "\\|";



	

	private static final SimpleDateFormat sdf = new SimpleDateFormat(

			"yyyy.MM.dd HH:mm:ss");

	 

	public static String getFileHeader() {

		return "ProcessDate|BatchId|BatchDate|RegionCode|DocumentId|DocumentDate|NumPages|CaseLinkId";

	}

	

	public static String formatMetadata(FnodMetadata data) {

		StringBuilder sb = new StringBuilder();

		sb.append(data.getProcessDt() == null ? "" : sdf.format(data.getProcessDt())).append(DELIMITER);

		sb.append(data.getBatchId() == null ? "" : data.getBatchId()).append(DELIMITER);

		sb.append(data.getBatchDate() == null ? "" : sdf.format(data.getBatchDate())).append(DELIMITER);

		sb.append(data.getRegionCode() == null ? "" : data.getRegionCode()).append(DELIMITER);

		sb.append(data.getDocumentId() == null ? "" : data.getDocumentId()).append(DELIMITER);

		sb.append(data.getDocumentDate() == null ? "" : sdf.format(data.getDocumentDate())).append(DELIMITER);

		sb.append(data.getNumPages() == null ? "" : data.getNumPages().toString()).append(DELIMITER);

		sb.append(data.getCaseLinkId() == null ? "" : data.getCaseLinkId().toString());

		return sb.toString();

	}

	

	public static FnodMetadata parseFormattedMetadata( String formattedMetadata) {

		

		String[] flds = formattedMetadata.split(splitRegex);

		

		FnodMetadata retval = new FnodMetadata();

		try {

			retval.setBatchId(flds[BATCH_ID]==null ? null :Long.valueOf(flds[BATCH_ID]));

			retval.setProcessDt(sdf.parse(flds[PROCESS_DATE]));

			retval.setBatchDate(sdf.parse(flds[BATCH_DATE]));

			retval.setRegionCode(flds[REGION_CD]==null ? null :Integer.valueOf(flds[REGION_CD]));

			retval.setDocumentId(flds[DOCUMENT_ID]==null ? null :Long.valueOf(flds[DOCUMENT_ID]));

			retval.setDocumentDate(sdf.parse(flds[DOCUMENT_DATE]));

			retval.setNumPages(flds[NUM_PAGES]==null ? null :Integer.valueOf(flds[NUM_PAGES]));

			// if there is a value for the last field, split does not return the element

			if ( flds.length == 8 ) {

				retval.setCaseLinkId(flds[CASE_LINK_ID]==null ? null :Long.valueOf(flds[CASE_LINK_ID]));

			} else {

				retval.setCaseLinkId(null);

			}

		} catch (ParseException ex) {

			throw new IllegalArgumentException("String not able to be parsed.");

		} catch (IndexOutOfBoundsException ex) {

			throw new IllegalArgumentException("String not able to be parsed.");

		}

		return retval;



	}

}

