package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.be.ProcessState;

import java.text.SimpleDateFormat;
import java.util.regex.Pattern;



public class FilenameHelper {

	

	private FilenameHelper() {

		super();

	}

	

	/**

	 * Used for the 

	 * @param ps

	 * @return

	 */ 	

	public static String getProcessTimeStamp(ProcessState ps) {

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");

		return sdf.format(ps.getProcessDate());

	}

	

	/** 

	 * Filename for archiving source data before starting process.

	 * 

	 * @param ps

	 * @return

	 */

	public static String getSourceArchiveFilename(ProcessState ps) {

		return String.format("%s.source.zip", getProcessTimeStamp(ps));

	}



	/**

	 * Filename for archiving transmitted Applications.

	 * 

	 * @param ps

	 * @return

	 */

	public static String getTransmitArchiveFilename(ProcessState ps) {

		return String.format("%s.transmit.zip", getProcessTimeStamp(ps));

	}



	

	public static String getProcessReportFilename(ProcessState ps) {

		return String.format("%s.process.csv", getProcessTimeStamp(ps));

	}



	public static String getTransmissionReportFilename(ProcessState ps) {

		return String.format("%s.transmit.csv", getProcessTimeStamp(ps));

	}

	

	public static String getProcessDataFilename(String documentId) {
		
		System.out.println("Dat file:: " + documentId+".dat");
		return documentId+".dat";

	}

	 	

	public static Pattern getProcessDataFilePattern() {

		return Pattern.compile("\\d*\\.dat");

	}

	

	public static String getSrcFileRegEx() {

		return "Batch\\d*.txt";

	}

	

	public static String getSummaryReportFilename(ProcessState ps) {

		return String.format("%s.summary.csv", getProcessTimeStamp(ps));

	}



	public static String getTransmitArchiveDir(ProcessState ps) {

		return String.format("%s.transmitted", getProcessTimeStamp(ps));

	}



	public static String getTempCompletedDirName(ProcessState ps) {

		return String.format("%s.completed", getProcessTimeStamp(ps));

	}



	public static String getCompeletedFileName(ProcessState ps) {

		return String.format("%s.completed.zip", getProcessTimeStamp(ps));

	}

	

	

}

