package gov.va.fnod.flagloader.bl;



import java.io.File;



public class DirectoryUtils {

	

	/**

	 * All files, including directories recursively, will be moved from the source directory to the

	 * destination directory.

	 * 

	 * The source and destination paths must already exist prior to execution of this method.  The 

	 * destination directory cannot be the same of as the source directory.  Violation of any of 

	 * these rules with result in an IllegalArgumentException.

	 * 

	 * @param srcDirPath

	 * @param destDirPath

	 */

	public static void moveContents(String srcDirPath, String destDirPath) {

		

		if ( srcDirPath == null || destDirPath==null ) {

			throw new IllegalArgumentException("srcDirPath and destDirPath cannot be null");

		}

		

		File srcDir = new File(srcDirPath);

		File destDir = new File(destDirPath);

		

		if ( srcDir != null && ! srcDir.isDirectory() ) {

			throw new IllegalArgumentException(String.format("srcDirPath [%s] must be an existing directory.",srcDirPath));

		}

		

		if ( destDir != null && ! destDir.isDirectory() ) {

			throw new IllegalArgumentException(String.format("destDirPath [%s] must be an existing directory.",srcDirPath));

		}

		

		if ( srcDir.equals(destDir) ) {

			throw new IllegalArgumentException("destDir must be different than srcDir");

		}

		

		for(File srcFile: srcDir.listFiles() ) {
			
			
			System.out.println("Moving file " + srcFile + " to " +  destDir);

			
			if ( ! srcFile.renameTo(new File(destDir, srcFile.getName())) ) {

				throw new RuntimeException(String.format("Failed to move %s to %s",

															srcFile.getAbsolutePath(), 

															destDir.getAbsolutePath()));

			}

				

		}

	}

	

	public static void removeFiles(String ... filePaths) {		

		for ( String filePath: filePaths) {

			removeFile(new File(filePath));

		}

	}

	

	public static void removeFiles(File ... files) {

		for ( File file: files ) {

			removeFile(file);

		}

	}

	

	public static void removeFile(File file) {

		

		if ( file.isDirectory() ) {

			for( File child: file.listFiles() ) {

				removeFile(child);	

			}

		}

		

		if ( file.exists() && !file.delete() ) {

			throw new RuntimeException("Failed to removed file: "+file.getAbsolutePath());

		}

	}



	

}

