package gov.va.fnod.flagloader.bl;



import java.io.BufferedInputStream;

import java.io.Closeable;

import java.io.File;

import java.io.FileInputStream;

import java.io.FileOutputStream;

import java.io.IOException;

import java.io.OutputStream;

import java.net.URI;

import java.util.Deque;

import java.util.LinkedList;

import java.util.zip.ZipEntry;

import java.util.zip.ZipOutputStream;



/**

 * This class archives a directory into the specified ZIP file by processing the

 * directory in a breadth first fashion, reducing the memory need by file lists.

 */

public class DirZipper {



	private DirZipper() {

		super();

	}



	public static void zipDir(File directory, File zipfile) throws IOException {

		URI base = directory.toURI();

		Deque<File> queue = new LinkedList<File>();

		queue.push(directory);

		OutputStream out = new FileOutputStream(zipfile);

		Closeable res = out;

		try {

			ZipOutputStream zout = new ZipOutputStream(out);

			res = zout;

			while (!queue.isEmpty()) {

				directory = queue.pop();

				for (File kid : directory.listFiles()) {

					String name = base.relativize(kid.toURI()).getPath();

					if (kid.isDirectory()) {

						queue.push(kid);

						name = name.endsWith("/") ? name : name + "/";

						zout.putNextEntry(new ZipEntry(name));

					} else {

						zout.putNextEntry(new ZipEntry(name));

						copy(kid, zout);

						zout.closeEntry();

					}

				}

			}

		} finally {

			res.close();

		}

	}



	private static void copy(File file, OutputStream out) throws IOException {



		BufferedInputStream bis = new BufferedInputStream(new FileInputStream(

				file));

		try {

			;

			byte[] bytes = new byte[8 * 1024];

			int bytesRead = 0;



			while ((bytesRead = bis.read(bytes)) > 0) {

				out.write(bytes, 0, bytesRead);

			}

		} finally {

			bis.close();

		}



	}

}

