package gov.va.fnod.flagloader.bl;



import gov.va.fnod.flagloader.be.ProcessState;



import java.io.File;

import java.io.IOException;



/**

 *  This class support adding and/or moving files into an archive file.  When files are added,

 *  the archive is opened, then the files are added and the archive is closed.

 */

public class Archiver {



	private File archiveDir;

	

	/**

	 * This is the only constructor and it require a non-null archive file.  The File object cannot be null. 

	 * If the file exists on the FileSystem, it will be appended to, if not a new file will be created.

	 * 

	 * @param archiveFile

	 */

	public Archiver(File workingDir, ProcessState state) {

		

		if ( state == null ) {

			throw new IllegalArgumentException("ProcessState required.");

		}

		

		if ( workingDir == null ) {

			throw new IllegalArgumentException("WorkingDir required");		

		}

		

		this.archiveDir = getArchiveDirectory(workingDir, state);

	}



	/**

	 * This methods takes a list of fully qualified file paths to be archived. 

	 * This method does not recurse sub-directories.

	 * 

	 * The list of files are first added to the archive, and then the files

	 * are delete. 

	 * 

	 * @param filePaths

	 */

	public void moveFilesToArchive(File workingDir, String... srcFilePaths) {

		

		for(String srcFilePath: srcFilePaths) {

			File src = new File(workingDir, srcFilePath);

			File dest = new File(archiveDir,src.getName());

			if ( !src.renameTo(dest) ) {

				throw new RuntimeException("Unable to archive: "+srcFilePath);

			}

		}

	}

	

	private File getArchiveDirectory(File workingDir, ProcessState ps) {

		File retval = new File(workingDir,FilenameHelper.getTransmitArchiveDir(ps));

		if ( !retval.isDirectory() ) {

			retval.mkdir();

		}

		return retval;

	}



	public void makeZip() {		

		try {

			DirZipper.zipDir(archiveDir, new File(archiveDir.getAbsolutePath()+".zip") );

			DirectoryUtils.removeFiles(archiveDir);

		} catch (IOException ex) {

			throw new RuntimeException("Failed to archive files",ex);

		}				

	}

		

	

}

