package gov.va.fnod.flagloader.be;



import java.util.Date;



/**

 * This class servers as the key for summarizing Flag Application process and

 * transmission data and is implemented as an immutable object. 

 */

public class ReportKey implements Comparable<ReportKey> {

	

	private Integer regionCode;

	private Date processDate;

	

	/**

	 * Since this class servers as a primary key, none of its member values

	 * can be null.  If either key value is null, an InvalidArgumentException will

	 * be thrown.

	 * 

	 * @param regionCode

	 * @param processDate

	 */

	public ReportKey(Integer regionCode, Date processDate) {

		

		if ( regionCode == null || processDate == null ) {

			throw new IllegalArgumentException("Key values cannot be null");

		}

		

		this.regionCode = regionCode;

		this.processDate = processDate;

	}

	

	/**

	 * Equals is based on all key fields.  The routine is simplified since all member

	 * variables are guaranteed to be not null.

	 */

	@Override

	public boolean equals(Object o) {

		boolean retval = false;

		if ( o instanceof ReportKey ) {

			ReportKey key = (ReportKey)o;

			retval = this.regionCode.equals(key.regionCode) && this.processDate.equals(key.processDate);							

		}

		return retval;	

	}

	

	/**

	 * HashCode is based in all member variables and is simplified by non-null member variables.

	 */

	@Override

	public int hashCode() {

		final int prime = 101;

		int result = 1;

		

		result = prime * result + regionCode.hashCode();

		result = prime * result	+ processDate.hashCode();

		

		return result;

	}



	/**

	 * compareTo is based on all member variables.

	 */

	

	public int compareTo(ReportKey key) {

		int retval = this.regionCode.compareTo(key.regionCode);

		if ( retval == 0 ) {

			retval = this.processDate.compareTo(key.processDate);

		}			

		return retval;

	}



	public Integer getRegionCode() {

		return regionCode;

	}



	public Date getProcessDate() {

		return processDate;

	}



}

